/*
 * Decompiled with CFR 0.152.
 */
package alpine.event.framework;

import alpine.event.framework.ChainLink;
import alpine.event.framework.ChainableEvent;
import alpine.event.framework.Event;
import alpine.event.framework.IEventService;
import java.util.ArrayList;
import java.util.UUID;

public abstract class AbstractChainableEvent
implements ChainableEvent {
    private final ArrayList<ChainLink> onSuccessChains = new ArrayList();
    private final ArrayList<ChainLink> onFailureChains = new ArrayList();
    private final UUID eventIdentifier = UUID.randomUUID();
    private UUID chainIdentifier = UUID.randomUUID();

    @Override
    public UUID getEventIdentifier() {
        return this.eventIdentifier;
    }

    @Override
    public UUID getChainIdentifier() {
        return this.chainIdentifier;
    }

    @Override
    public void setChainIdentifier(UUID chainIdentifier) {
        this.chainIdentifier = chainIdentifier;
    }

    @Override
    public ChainLink[] onSuccess() {
        ChainLink[] chain = new ChainLink[this.onSuccessChains.size()];
        return this.onSuccessChains.toArray(chain);
    }

    @Override
    public ChainLink[] onFailure() {
        ChainLink[] chain = new ChainLink[this.onFailureChains.size()];
        return this.onFailureChains.toArray(chain);
    }

    @Override
    public ChainableEvent onSuccess(Event onSuccessEvent) {
        this.onSuccessChains.add(new ChainLink().onSuccess(this.linkChainIdentifier(onSuccessEvent)));
        return this;
    }

    @Override
    public ChainableEvent onSuccess(Event onSuccessEvent, Class<? extends IEventService> onSuccessEventService) {
        this.onSuccessChains.add(new ChainLink().onSuccess(this.linkChainIdentifier(onSuccessEvent), onSuccessEventService));
        return this;
    }

    @Override
    public ChainableEvent onFailure(Event onFailureEvent) {
        this.onFailureChains.add(new ChainLink().onFailure(this.linkChainIdentifier(onFailureEvent)));
        return this;
    }

    @Override
    public ChainableEvent onFailure(Event onFailureEvent, Class<? extends IEventService> onFailureEventService) {
        this.onFailureChains.add(new ChainLink().onFailure(this.linkChainIdentifier(onFailureEvent), onFailureEventService));
        return this;
    }

    private Event linkChainIdentifier(Event event) {
        if (event instanceof ChainableEvent) {
            ChainableEvent chainableEvent = (ChainableEvent)event;
            chainableEvent.setChainIdentifier(this.getChainIdentifier());
            return chainableEvent;
        }
        return event;
    }
}

