/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import alpine.common.validation.RegexSequence;
import alpine.persistence.IPersistenceManagerFactory;
import alpine.persistence.NotSortableException;
import alpine.persistence.OrderDirection;
import alpine.persistence.PaginatedResult;
import alpine.persistence.Pagination;
import alpine.persistence.ScopedCustomization;
import alpine.persistence.Transaction;
import alpine.resources.AlpineRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.jdo.PersistenceManager;
import javax.jdo.metadata.MemberMetadata;
import javax.jdo.metadata.TypeMetadata;
import org.apache.commons.collections4.CollectionUtils;
import org.datanucleus.api.jdo.JDOQuery;
import org.datanucleus.store.query.Query;

public abstract class AbstractAlpineQueryManager
implements AutoCloseable {
    private static final ServiceLoader<IPersistenceManagerFactory> IpmfServiceLoader = ServiceLoader.load(IPersistenceManagerFactory.class);
    protected final Principal principal;
    protected Pagination pagination;
    protected final String filter;
    protected final String orderBy;
    protected final OrderDirection orderDirection;
    protected final PersistenceManager pm;

    public static Optional<IPersistenceManagerFactory> getPersistenceManagerFactory() {
        return IpmfServiceLoader.findFirst();
    }

    public AbstractAlpineQueryManager(PersistenceManager pm) {
        this.pm = pm;
        this.principal = null;
        this.pagination = new Pagination(Pagination.Strategy.NONE, 0, 0);
        this.filter = null;
        this.orderBy = null;
        this.orderDirection = OrderDirection.UNSPECIFIED;
    }

    public AbstractAlpineQueryManager() {
        Optional<IPersistenceManagerFactory> ipmf = AbstractAlpineQueryManager.getPersistenceManagerFactory();
        this.pm = ipmf.isEmpty() ? null : ipmf.get().getPersistenceManager();
        this.principal = null;
        this.pagination = new Pagination(Pagination.Strategy.NONE, 0, 0);
        this.filter = null;
        this.orderBy = null;
        this.orderDirection = OrderDirection.UNSPECIFIED;
    }

    public AbstractAlpineQueryManager(Principal principal, Pagination pagination, String filter, String orderBy, OrderDirection orderDirection) {
        Optional<IPersistenceManagerFactory> ipmf = AbstractAlpineQueryManager.getPersistenceManagerFactory();
        this.pm = ipmf.isEmpty() ? null : ipmf.get().getPersistenceManager();
        this.principal = principal;
        this.pagination = pagination;
        this.filter = filter;
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
    }

    public AbstractAlpineQueryManager(AlpineRequest request) {
        Optional<IPersistenceManagerFactory> ipmf = AbstractAlpineQueryManager.getPersistenceManagerFactory();
        this.pm = ipmf.isEmpty() ? null : ipmf.get().getPersistenceManager();
        this.principal = request.getPrincipal();
        this.pagination = request.getPagination();
        this.filter = request.getFilter();
        this.orderBy = request.getOrderBy();
        this.orderDirection = request.getOrderDirection();
    }

    public AbstractAlpineQueryManager(PersistenceManager pm, AlpineRequest request) {
        this.pm = pm;
        this.principal = request.getPrincipal();
        this.pagination = request.getPagination();
        this.filter = request.getFilter();
        this.orderBy = request.getOrderBy();
        this.orderDirection = request.getOrderDirection();
    }

    public PaginatedResult execute(javax.jdo.Query<?> query, Object ... parameters) {
        long count = this.getCount(query, parameters);
        this.decorate(query);
        return new PaginatedResult().objects(this.executeAndCloseWithArray(query, parameters)).total(count);
    }

    public PaginatedResult execute(javax.jdo.Query<?> query, Map<String, Object> parameters) {
        long count = this.getCount(query, parameters);
        this.decorate(query);
        return new PaginatedResult().objects(this.executeAndCloseWithMap(query, parameters)).total(count);
    }

    public void advancePagination() {
        if (this.pagination.isPaginated()) {
            this.pagination = new Pagination(this.pagination.getStrategy(), this.pagination.getOffset() + this.pagination.getLimit(), this.pagination.getLimit());
        }
    }

    public <T> javax.jdo.Query<T> decorate(javax.jdo.Query<T> query) {
        query.setResult(null);
        if (this.pagination != null && this.pagination.isPaginated()) {
            long begin = this.pagination.getOffset();
            long end = begin + (long)this.pagination.getLimit();
            query.setRange(begin, end);
        }
        if (this.orderBy != null && RegexSequence.Pattern.STRING_IDENTIFIER.matcher(this.orderBy).matches() && this.orderDirection != OrderDirection.UNSPECIFIED) {
            boolean found = false;
            Query iq = ((JDOQuery)query).getInternalQuery();
            String candidateField = this.orderBy.contains(".") ? this.orderBy.substring(0, this.orderBy.indexOf(46)) : this.orderBy;
            TypeMetadata candidateTypeMetadata = this.pm.getPersistenceManagerFactory().getMetadata(iq.getCandidateClassName());
            if (candidateTypeMetadata == null) {
                throw new IllegalStateException("Persistence type metadata for candidate class %s could not be found. Querying for non-persistent types is not supported, correct your query.".formatted(iq.getCandidateClassName()));
            }
            boolean foundPersistentMember = false;
            for (MemberMetadata memberMetadata : candidateTypeMetadata.getMembers()) {
                if (!candidateField.equals(memberMetadata.getName())) continue;
                foundPersistentMember = true;
                break;
            }
            if (foundPersistentMember) {
                query.setOrdering(this.orderBy + " " + this.orderDirection.name().toLowerCase());
            } else {
                boolean foundNonPersistentMember = Arrays.stream(iq.getCandidateClass().getDeclaredFields()).anyMatch(field -> field.getName().equals(candidateField));
                if (foundNonPersistentMember) {
                    throw new NotSortableException(iq.getCandidateClass().getSimpleName(), candidateField, "The field is computed and can not be queried or sorted by");
                }
                throw new NotSortableException(iq.getCandidateClass().getSimpleName(), candidateField, "The field does not exist");
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount(javax.jdo.Query<?> query, Object ... parameters) {
        Query internalQuery = ((JDOQuery)query).getInternalQuery();
        String originalOrdering = internalQuery.getOrdering();
        query.setOrdering(null);
        query.setResult("count(this)");
        try {
            long l = (Long)query.executeWithArray(parameters);
            return l;
        }
        finally {
            query.setOrdering(originalOrdering);
            query.setResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount(javax.jdo.Query<?> query, Map<String, Object> parameters) {
        Query internalQuery = ((JDOQuery)query).getInternalQuery();
        String originalOrdering = internalQuery.getOrdering();
        query.setOrdering(null);
        query.setResult("count(this)");
        try {
            long l = (Long)query.executeWithMap(parameters);
            return l;
        }
        finally {
            query.setOrdering(originalOrdering);
            query.setResult(null);
        }
    }

    public <T> long getCount(Class<T> cls) {
        javax.jdo.Query query = this.pm.newQuery(cls);
        query.setResult("count(id)");
        return this.executeAndCloseResultUnique(query, Long.class);
    }

    public <T> T persist(T object) {
        return (T)this.callInTransaction(() -> this.pm.makePersistent(object));
    }

    public <T> T[] persist(T ... pcs) {
        return this.callInTransaction(() -> this.pm.makePersistentAll(pcs));
    }

    public <T> Collection<T> persist(Collection<T> pcs) {
        return this.callInTransaction(() -> this.pm.makePersistentAll(pcs));
    }

    public void delete(Object ... objects) {
        this.runInTransaction(() -> this.pm.deletePersistentAll(objects));
    }

    public void delete(Collection<?> collection) {
        this.runInTransaction(() -> this.pm.deletePersistentAll(collection));
    }

    public <T> T detach(Class<T> clazz, Object id) {
        try (ScopedCustomization ignored = new ScopedCustomization(this.pm).withDetachmentOptions(1);){
            Object object = this.pm.detachCopy(this.pm.getObjectById(clazz, id));
            return (T)object;
        }
    }

    public <T> T detach(T object) {
        try (ScopedCustomization ignored = new ScopedCustomization(this.pm).withDetachmentOptions(1);){
            Object object2 = this.pm.detachCopy(object);
            return (T)object2;
        }
    }

    public <T> List<T> detach(List<T> pcs) {
        try (ScopedCustomization ignored = new ScopedCustomization(this.pm).withDetachmentOptions(1);){
            ArrayList arrayList = new ArrayList(this.pm.detachCopyAll(pcs));
            return arrayList;
        }
    }

    public <T> Set<T> detach(Set<T> pcs) {
        try (ScopedCustomization ignored = new ScopedCustomization(this.pm).withDetachmentOptions(1);){
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.pm.detachCopyAll(pcs));
            return linkedHashSet;
        }
    }

    public <T> T makeTransient(T object) {
        this.pm.makeTransient(object);
        return object;
    }

    public <T, C extends Collection<T>> C makeTransientAll(C collection) {
        this.pm.makeTransientAll(collection);
        return collection;
    }

    public <T> T getObjectById(Class<T> clazz, Object id) {
        return (T)this.pm.getObjectById(clazz, id);
    }

    public <T> T getObjectByUuid(Class<T> clazz, UUID uuid) {
        javax.jdo.Query query = this.pm.newQuery(clazz, "uuid == :uuid");
        query.setParameters(new Object[]{uuid});
        return this.executeAndCloseUnique(query);
    }

    public <T> T getObjectByUuid(Class<T> clazz, String uuid) {
        return this.getObjectByUuid(clazz, UUID.fromString(uuid));
    }

    public <T> T getObjectByUuid(Class<T> clazz, UUID uuid, String fetchGroup) {
        javax.jdo.Query query = this.pm.newQuery(clazz, "uuid == :uuid");
        query.getFetchPlan().addGroup(fetchGroup);
        query.setParameters(new Object[]{uuid});
        return this.executeAndCloseUnique(query);
    }

    public <T> T getObjectByUuid(Class<T> clazz, String uuid, String fetchGroup) {
        return this.getObjectByUuid(clazz, UUID.fromString(uuid), fetchGroup);
    }

    public <T> T singleResult(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Collection result = (Collection)object;
            return CollectionUtils.isEmpty((Collection)result) ? null : (T)result.iterator().next();
        }
        return null;
    }

    @Override
    public void close() {
        if (this.pm != null) {
            this.pm.close();
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public <T> T callInTransaction(Transaction.Options options, Callable<T> callable) {
        return Transaction.call(this.pm, options, callable);
    }

    public <T> T callInTransaction(Callable<T> callable) {
        return this.callInTransaction(Transaction.defaultOptions(), callable);
    }

    public void runInTransaction(Transaction.Options options, Runnable runnable) {
        this.callInTransaction(options, () -> {
            runnable.run();
            return null;
        });
    }

    public void runInTransaction(Runnable runnable) {
        this.runInTransaction(Transaction.defaultOptions(), runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeAndClose(javax.jdo.Query<?> query) {
        try {
            Object result = query.execute();
            if (result instanceof Collection) {
                Collection resultCollection = (Collection)result;
                ArrayList arrayList = new ArrayList(resultCollection);
                return arrayList;
            }
            Object object = result;
            return object;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeAndCloseWithArray(javax.jdo.Query<?> query, Object ... parameters) {
        try {
            Object result = query.executeWithArray(parameters);
            if (result instanceof Collection) {
                Collection resultCollection = (Collection)result;
                ArrayList arrayList = new ArrayList(resultCollection);
                return arrayList;
            }
            Object object = result;
            return object;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeAndCloseWithMap(javax.jdo.Query<?> query, Map<String, Object> parameters) {
        try {
            Object result = query.executeWithMap(parameters);
            if (result instanceof Collection) {
                Collection resultCollection = (Collection)result;
                ArrayList arrayList = new ArrayList(resultCollection);
                return arrayList;
            }
            Object object = result;
            return object;
        }
        finally {
            query.closeAll();
        }
    }

    protected <T> T executeAndCloseUnique(javax.jdo.Query<T> query) {
        try {
            Object object = query.executeUnique();
            return (T)object;
        }
        finally {
            query.closeAll();
        }
    }

    protected <T> List<T> executeAndCloseList(javax.jdo.Query<T> query) {
        try {
            ArrayList arrayList = new ArrayList(query.executeList());
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T executeAndCloseResultUnique(javax.jdo.Query<?> query, Class<T> resultClass) {
        try {
            Object object = query.executeResultUnique(resultClass);
            return (T)object;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> executeAndCloseResultList(javax.jdo.Query<?> query, Class<T> resultClass) {
        try {
            ArrayList arrayList = new ArrayList(query.executeResultList(resultClass));
            return arrayList;
        }
        finally {
            query.closeAll();
        }
    }
}

