/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import alpine.common.logging.Logger;
import alpine.event.LdapSyncEvent;
import alpine.event.framework.EventService;
import alpine.event.framework.LoggableSubscriber;
import alpine.event.framework.Subscriber;
import alpine.model.ApiKey;
import alpine.model.ConfigProperty;
import alpine.model.EventServiceLog;
import alpine.model.IConfigProperty;
import alpine.model.LdapUser;
import alpine.model.ManagedUser;
import alpine.model.MappedLdapGroup;
import alpine.model.MappedOidcGroup;
import alpine.model.OidcGroup;
import alpine.model.OidcUser;
import alpine.model.Permission;
import alpine.model.Team;
import alpine.model.UserPrincipal;
import alpine.persistence.AbstractAlpineQueryManager;
import alpine.resources.AlpineRequest;
import alpine.security.ApiKeyGenerator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class AlpineQueryManager
extends AbstractAlpineQueryManager {
    private static final Logger LOGGER = Logger.getLogger(AlpineQueryManager.class);

    public AlpineQueryManager() {
    }

    public AlpineQueryManager(PersistenceManager pm) {
        super(pm);
    }

    public AlpineQueryManager(AlpineRequest request) {
        super(request);
    }

    public AlpineQueryManager(PersistenceManager pm, AlpineRequest request) {
        super(pm, request);
    }

    public ApiKey getApiKey(String key) {
        return this.callInTransaction(() -> {
            Query query = this.pm.newQuery(ApiKey.class, "key == :key");
            query.setParameters(new Object[]{key});
            return (ApiKey)this.executeAndCloseUnique(query);
        });
    }

    public ApiKey regenerateApiKey(ApiKey apiKey) {
        return this.callInTransaction(() -> {
            apiKey.setKey(ApiKeyGenerator.generate());
            return apiKey;
        });
    }

    public ApiKey createApiKey(Team team) {
        return this.callInTransaction(() -> {
            ApiKey apiKey = new ApiKey();
            apiKey.setKey(ApiKeyGenerator.generate());
            apiKey.setCreated(new Date());
            apiKey.setTeams(List.of(team));
            return (ApiKey)this.pm.makePersistent((Object)apiKey);
        });
    }

    public ApiKey updateApiKey(ApiKey transientApiKey) {
        return this.callInTransaction(() -> {
            ApiKey apiKey = this.getObjectById(ApiKey.class, transientApiKey.getId());
            apiKey.setComment(transientApiKey.getComment());
            return apiKey;
        });
    }

    public OidcUser createOidcUser(String username) {
        return this.callInTransaction(() -> {
            OidcUser user = new OidcUser();
            user.setUsername(username);
            return (OidcUser)this.pm.makePersistent((Object)user);
        });
    }

    public OidcUser updateOidcUser(OidcUser transientUser) {
        return this.callInTransaction(() -> {
            OidcUser user = this.getObjectById(OidcUser.class, transientUser.getId());
            user.setSubjectIdentifier(transientUser.getSubjectIdentifier());
            user.setEmail(transientUser.getEmail());
            return user;
        });
    }

    public OidcUser getOidcUser(String username) {
        Query query = this.pm.newQuery(OidcUser.class, "username == :username");
        query.setParameters(new Object[]{username});
        return (OidcUser)this.executeAndCloseUnique(query);
    }

    public List<OidcUser> getOidcUsers() {
        Query query = this.pm.newQuery(OidcUser.class);
        query.setOrdering("username asc");
        return this.executeAndCloseList(query);
    }

    public OidcGroup createOidcGroup(String name) {
        return this.callInTransaction(() -> {
            OidcGroup group = new OidcGroup();
            group.setName(name);
            return (OidcGroup)this.pm.makePersistent((Object)group);
        });
    }

    public OidcGroup updateOidcGroup(OidcGroup oidcGroup) {
        return this.callInTransaction(() -> {
            OidcGroup oidcGroupToUpdate = this.getObjectByUuid(OidcGroup.class, oidcGroup.getUuid());
            oidcGroupToUpdate.setName(oidcGroup.getName());
            return oidcGroupToUpdate;
        });
    }

    public List<OidcGroup> getOidcGroups() {
        Query query = this.pm.newQuery(OidcGroup.class);
        query.setOrdering("name asc");
        return this.executeAndCloseList(query);
    }

    public OidcGroup getOidcGroup(String name) {
        Query query = this.pm.newQuery(OidcGroup.class, "name == :name");
        query.setParameters(new Object[]{name});
        return (OidcGroup)this.executeAndCloseUnique(query);
    }

    public OidcUser synchronizeTeamMembership(OidcUser user, List<String> groupNames) {
        LOGGER.debug("Synchronizing team membership for OpenID Connect user " + user.getUsername());
        return this.callInTransaction(() -> {
            ArrayList<Team> removeThese = new ArrayList<Team>();
            if (user.getTeams() != null) {
                for (Team team : user.getTeams()) {
                    LOGGER.debug(user.getUsername() + " is a member of team: " + team.getName());
                    if (team.getMappedOidcGroups() != null && !team.getMappedOidcGroups().isEmpty()) {
                        for (MappedOidcGroup mappedOidcGroup : team.getMappedOidcGroups()) {
                            LOGGER.debug(mappedOidcGroup.getGroup().getName() + " is mapped to team: " + team.getName());
                            if (groupNames.contains(mappedOidcGroup.getGroup().getName())) continue;
                            LOGGER.debug(mappedOidcGroup.getGroup().getName() + " is not identified in the List of groups specified. Queuing removal of membership for user " + user.getUsername());
                            removeThese.add(team);
                        }
                        continue;
                    }
                    LOGGER.debug(team.getName() + " does not have any mapped OpenID Connect groups. Queuing removal of " + user.getUsername() + " from team: " + team.getName());
                    removeThese.add(team);
                }
            }
            for (Team team : removeThese) {
                LOGGER.debug("Removing user: " + user.getUsername() + " from team: " + team.getName());
                this.removeUserFromTeam((UserPrincipal)user, team);
            }
            for (String groupName : groupNames) {
                OidcGroup group = this.getOidcGroup(groupName);
                if (group == null) {
                    LOGGER.debug("Unknown OpenID Connect group " + groupName);
                    continue;
                }
                for (MappedOidcGroup mappedOidcGroup : this.getMappedOidcGroups(group)) {
                    LOGGER.debug("Adding user: " + user.getUsername() + " to team: " + mappedOidcGroup.getTeam().getName());
                    this.addUserToTeam((UserPrincipal)user, mappedOidcGroup.getTeam());
                }
            }
            return user;
        });
    }

    public OidcUser addUserToTeams(OidcUser user, List<String> teamNames) {
        LOGGER.debug("Synchronizing team membership for OpenID Connect user " + user.getUsername());
        return this.callInTransaction(() -> {
            for (String teamName : teamNames) {
                Team team = this.getTeam(teamName);
                if (team == null) {
                    LOGGER.warn("Cannot add user " + user.getUsername() + " to team " + teamName + ", because no team with that name exists");
                    continue;
                }
                LOGGER.debug("Adding user: " + user.getUsername() + " to team: " + teamName);
                this.addUserToTeam((UserPrincipal)user, team);
            }
            return user;
        });
    }

    public LdapUser getLdapUser(String username) {
        Query query = this.pm.newQuery(LdapUser.class, "username == :username");
        query.setParameters(new Object[]{username});
        return (LdapUser)this.executeAndCloseUnique(query);
    }

    public List<LdapUser> getLdapUsers() {
        Query query = this.pm.newQuery(LdapUser.class);
        query.setOrdering("username asc");
        return this.executeAndCloseList(query);
    }

    public LdapUser createLdapUser(String username) {
        LdapUser createdUser = this.callInTransaction(() -> {
            LdapUser user = new LdapUser();
            user.setUsername(username);
            user.setDN("Syncing...");
            return (LdapUser)this.pm.makePersistent((Object)user);
        });
        EventService.getInstance().publish(new LdapSyncEvent(createdUser.getUsername()));
        return createdUser;
    }

    public LdapUser updateLdapUser(LdapUser transientUser) {
        return this.callInTransaction(() -> {
            LdapUser user = this.getObjectById(LdapUser.class, transientUser.getId());
            user.setDN(transientUser.getDN());
            return user;
        });
    }

    public LdapUser synchronizeTeamMembership(LdapUser user, List<String> groupDNs) {
        LOGGER.debug("Synchronizing team membership for " + user.getUsername());
        return this.callInTransaction(() -> {
            ArrayList<Team> removeThese = new ArrayList<Team>();
            if (user.getTeams() != null) {
                for (Team team : user.getTeams()) {
                    LOGGER.debug(user.getUsername() + " is a member of team: " + team.getName());
                    if (team.getMappedLdapGroups() != null) {
                        for (MappedLdapGroup mappedLdapGroup : team.getMappedLdapGroups()) {
                            LOGGER.debug(mappedLdapGroup.getDn() + " is mapped to team: " + team.getName());
                            if (groupDNs.contains(mappedLdapGroup.getDn())) continue;
                            LOGGER.debug(mappedLdapGroup.getDn() + " is not identified in the List of group DNs specified. Queuing removal of membership for user " + user.getUsername());
                            removeThese.add(team);
                        }
                        continue;
                    }
                    LOGGER.debug(team.getName() + " does not have any mapped LDAP groups. Queuing removal of " + user.getUsername() + " from team: " + team.getName());
                    removeThese.add(team);
                }
            }
            for (Team team : removeThese) {
                LOGGER.debug("Removing user: " + user.getUsername() + " from team: " + team.getName());
                this.removeUserFromTeam((UserPrincipal)user, team);
            }
            for (String groupDN : groupDNs) {
                for (MappedLdapGroup mappedLdapGroup : this.getMappedLdapGroups(groupDN)) {
                    LOGGER.debug("Adding user: " + user.getUsername() + " to team: " + String.valueOf(mappedLdapGroup.getTeam()));
                    this.addUserToTeam((UserPrincipal)user, mappedLdapGroup.getTeam());
                }
            }
            return user;
        });
    }

    public ManagedUser createManagedUser(String username, String passwordHash) {
        return this.createManagedUser(username, null, null, passwordHash, false, false, false);
    }

    public ManagedUser createManagedUser(String username, String fullname, String email, String passwordHash, boolean forcePasswordChange, boolean nonExpiryPassword, boolean suspended) {
        return this.callInTransaction(() -> {
            ManagedUser user = new ManagedUser();
            user.setUsername(username);
            user.setFullname(fullname);
            user.setEmail(email);
            user.setPassword(passwordHash);
            user.setForcePasswordChange(forcePasswordChange);
            user.setNonExpiryPassword(nonExpiryPassword);
            user.setSuspended(suspended);
            user.setLastPasswordChange(new Date());
            return (ManagedUser)this.pm.makePersistent((Object)user);
        });
    }

    public ManagedUser updateManagedUser(ManagedUser transientUser) {
        return this.callInTransaction(() -> {
            ManagedUser user = this.getObjectById(ManagedUser.class, transientUser.getId());
            user.setFullname(transientUser.getFullname());
            user.setEmail(transientUser.getEmail());
            user.setForcePasswordChange(transientUser.isForcePasswordChange());
            user.setNonExpiryPassword(transientUser.isNonExpiryPassword());
            user.setSuspended(transientUser.isSuspended());
            if (transientUser.getPassword() != null) {
                if (!user.getPassword().equals(transientUser.getPassword())) {
                    user.setLastPasswordChange(new Date());
                }
                user.setPassword(transientUser.getPassword());
            }
            return user;
        });
    }

    public ManagedUser getManagedUser(String username) {
        Query query = this.pm.newQuery(ManagedUser.class, "username == :username");
        query.setParameters(new Object[]{username});
        return (ManagedUser)this.executeAndCloseUnique(query);
    }

    public List<ManagedUser> getManagedUsers() {
        Query query = this.pm.newQuery(ManagedUser.class);
        query.setOrdering("username asc");
        return this.executeAndCloseList(query);
    }

    public UserPrincipal getUserPrincipal(String username) {
        ManagedUser principal = this.getManagedUser(username);
        if (principal != null) {
            return principal;
        }
        principal = this.getLdapUser(username);
        if (principal != null) {
            return principal;
        }
        return this.getOidcUser(username);
    }

    public Team createTeam(String name, boolean createApiKey) {
        return this.callInTransaction(() -> {
            Team team = new Team();
            team.setName(name);
            this.pm.makePersistent((Object)team);
            if (createApiKey) {
                this.createApiKey(team);
            }
            return team;
        });
    }

    public List<Team> getTeams() {
        Query query = this.pm.newQuery(Team.class);
        query.getFetchPlan().addGroup(Team.FetchGroup.ALL.name());
        query.setOrdering("name asc");
        return this.executeAndCloseList(query);
    }

    public Team getTeam(String name) {
        Query query = this.pm.newQuery(Team.class, "name == :name");
        query.setParameters(new Object[]{name});
        return (Team)this.executeAndCloseUnique(query);
    }

    public Team updateTeam(Team transientTeam) {
        return this.callInTransaction(() -> {
            Team team = this.getObjectByUuid(Team.class, transientTeam.getUuid());
            team.setName(transientTeam.getName());
            return team;
        });
    }

    public boolean addUserToTeam(UserPrincipal user, Team team) {
        return this.callInTransaction(() -> {
            ArrayList<Team> teams = user.getTeams();
            boolean found = false;
            if (teams == null) {
                teams = new ArrayList<Team>();
            }
            for (Team t : teams) {
                if (!team.getUuid().equals(t.getUuid())) continue;
                found = true;
            }
            if (!found) {
                teams.add(team);
                user.setTeams(teams);
                return true;
            }
            return false;
        });
    }

    public boolean removeUserFromTeam(UserPrincipal user, Team team) {
        return this.callInTransaction(() -> {
            List teams = user.getTeams();
            if (teams == null) {
                return false;
            }
            boolean found = false;
            for (Team t : teams) {
                if (!team.getUuid().equals(t.getUuid())) continue;
                found = true;
            }
            if (found) {
                teams.remove(team);
                user.setTeams(teams);
                return true;
            }
            return false;
        });
    }

    public Permission createPermission(String name, String description) {
        return this.callInTransaction(() -> {
            Permission permission = new Permission();
            permission.setName(name);
            permission.setDescription(description);
            return (Permission)this.pm.makePersistent((Object)permission);
        });
    }

    public Permission getPermission(String name) {
        Query query = this.pm.newQuery(Permission.class, "name == :name");
        query.setParameters(new Object[]{name});
        return (Permission)this.executeAndCloseUnique(query);
    }

    public List<Permission> getPermissions() {
        Query query = this.pm.newQuery(Permission.class);
        query.setOrdering("name asc");
        return this.executeAndCloseList(query);
    }

    public List<Permission> getEffectivePermissions(UserPrincipal user) {
        LinkedHashSet permissions = new LinkedHashSet();
        if (user.getPermissions() != null) {
            permissions.addAll(user.getPermissions());
        }
        if (user.getTeams() != null) {
            for (Team team : user.getTeams()) {
                List teamPermissions = this.getObjectById(Team.class, team.getId()).getPermissions();
                if (teamPermissions == null) continue;
                permissions.addAll(teamPermissions);
            }
        }
        return new ArrayList<Permission>(permissions);
    }

    public boolean hasPermission(UserPrincipal user, String permissionName) {
        return this.hasPermission(user, permissionName, false);
    }

    public boolean hasPermission(UserPrincipal user, String permissionName, boolean includeTeams) {
        Query query;
        if (user instanceof ManagedUser) {
            ManagedUser managedUser = (ManagedUser)user;
            query = this.pm.newQuery(Permission.class, "name == :permissionName && managedUsers.contains(user) && user.id == :userId");
            query.declareVariables("alpine.model.ManagedUser user");
            query.setParameters(new Object[]{permissionName, managedUser.getId()});
        } else if (user instanceof LdapUser) {
            LdapUser ldapUser = (LdapUser)user;
            query = this.pm.newQuery(Permission.class, "name == :permissionName && ldapUsers.contains(user) && user.id == :userId");
            query.declareVariables("alpine.model.LdapUser user");
            query.setParameters(new Object[]{permissionName, ldapUser.getId()});
        } else if (user instanceof OidcUser) {
            OidcUser oidcUser = (OidcUser)user;
            query = this.pm.newQuery(Permission.class, "name == :permissionName && oidcUsers.contains(user) && user.id == :userId");
            query.declareVariables("alpine.model.OidcUser user");
            query.setParameters(new Object[]{permissionName, oidcUser.getId()});
        } else {
            LOGGER.warn("Unrecognized principal class %s; Unable to verify permissions".formatted(user.getClass()));
            return false;
        }
        query.setResult("count(id)");
        long count = (Long)query.executeResultUnique(Long.class);
        if (count > 0L) {
            return true;
        }
        if (includeTeams) {
            for (Team team : user.getTeams()) {
                if (!this.hasPermission(team, permissionName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPermission(Team team, String permissionName) {
        Query query = this.pm.newQuery(Permission.class, "name == :permissionName && teams.contains(team) && team.id == :teamId");
        query.declareVariables("alpine.model.Team team");
        query.setParameters(new Object[]{permissionName, team.getId()});
        query.setResult("count(id)");
        return this.executeAndCloseResultUnique(query, Long.class) > 0L;
    }

    public boolean hasPermission(ApiKey apiKey, String permissionName) {
        if (apiKey.getTeams() == null) {
            return false;
        }
        for (Team team : apiKey.getTeams()) {
            List teamPermissions = this.getObjectById(Team.class, team.getId()).getPermissions();
            for (Permission permission : teamPermissions) {
                if (!permission.getName().equals(permissionName)) continue;
                return true;
            }
        }
        return false;
    }

    public MappedLdapGroup getMappedLdapGroup(Team team, String dn) {
        Query query = this.pm.newQuery(MappedLdapGroup.class, "team == :team && dn == :dn");
        query.setParameters(new Object[]{team, dn});
        return (MappedLdapGroup)this.executeAndCloseUnique(query);
    }

    public List<MappedLdapGroup> getMappedLdapGroups(Team team) {
        Query query = this.pm.newQuery(MappedLdapGroup.class, "team == :team");
        query.setParameters(new Object[]{team});
        return this.executeAndCloseList(query);
    }

    public List<MappedLdapGroup> getMappedLdapGroups(String dn) {
        Query query = this.pm.newQuery(MappedLdapGroup.class, "dn == :dn");
        query.setParameters(new Object[]{dn});
        return this.executeAndCloseList(query);
    }

    public boolean isMapped(Team team, String dn) {
        return this.getMappedLdapGroup(team, dn) != null;
    }

    public MappedLdapGroup createMappedLdapGroup(Team team, String dn) {
        return this.callInTransaction(() -> {
            MappedLdapGroup mapping = new MappedLdapGroup();
            mapping.setTeam(team);
            mapping.setDn(dn);
            return (MappedLdapGroup)this.pm.makePersistent((Object)mapping);
        });
    }

    public MappedOidcGroup createMappedOidcGroup(Team team, OidcGroup group) {
        return this.callInTransaction(() -> {
            MappedOidcGroup mapping = new MappedOidcGroup();
            mapping.setTeam(team);
            mapping.setGroup(group);
            return (MappedOidcGroup)this.pm.makePersistent((Object)mapping);
        });
    }

    public MappedOidcGroup getMappedOidcGroup(Team team, OidcGroup group) {
        Query query = this.pm.newQuery(MappedOidcGroup.class, "team == :team && group == :group");
        query.setParameters(new Object[]{team, group});
        return (MappedOidcGroup)this.executeAndCloseUnique(query);
    }

    public List<MappedOidcGroup> getMappedOidcGroups(Team team) {
        Query query = this.pm.newQuery(MappedOidcGroup.class, "team == :team");
        query.setParameters(new Object[]{team});
        return this.executeAndCloseList(query);
    }

    public List<MappedOidcGroup> getMappedOidcGroups(OidcGroup group) {
        Query query = this.pm.newQuery(MappedOidcGroup.class, "group == :group");
        query.setParameters(new Object[]{group});
        return this.executeAndCloseList(query);
    }

    public boolean isOidcGroupMapped(Team team, OidcGroup group) {
        return this.getMappedOidcGroup(team, group) != null;
    }

    public EventServiceLog createEventServiceLog(Class<? extends Subscriber> clazz) {
        if (LoggableSubscriber.class.isAssignableFrom(clazz)) {
            this.callInTransaction(() -> {
                EventServiceLog log = new EventServiceLog();
                log.setSubscriberClass(clazz.getCanonicalName());
                log.setStarted(new Timestamp(new Date().getTime()));
                return (EventServiceLog)this.pm.makePersistent((Object)log);
            });
        }
        return null;
    }

    public EventServiceLog updateEventServiceLog(EventServiceLog eventServiceLog) {
        if (eventServiceLog == null) {
            return null;
        }
        return this.callInTransaction(() -> {
            EventServiceLog log = this.getObjectById(EventServiceLog.class, eventServiceLog.getId());
            if (log != null) {
                log.setCompleted(new Timestamp(new Date().getTime()));
                return log;
            }
            return null;
        });
    }

    public EventServiceLog getLatestEventServiceLog(Class<LoggableSubscriber> clazz) {
        Query query = this.pm.newQuery(EventServiceLog.class, "eventClass == :clazz");
        query.setParameters(new Object[]{clazz});
        query.setOrdering("completed desc");
        query.setRange(0L, 1L);
        return (EventServiceLog)this.executeAndCloseUnique(query);
    }

    public ConfigProperty getConfigProperty(String groupName, String propertyName) {
        Query query = this.pm.newQuery(ConfigProperty.class, "groupName == :groupName && propertyName == :propertyName");
        query.setParameters(new Object[]{groupName, propertyName});
        return (ConfigProperty)this.executeAndCloseUnique(query);
    }

    public List<ConfigProperty> getConfigProperties(String groupName) {
        Query query = this.pm.newQuery(ConfigProperty.class, "groupName == :groupName");
        query.setParameters(new Object[]{groupName});
        query.setOrdering("propertyName asc");
        return this.executeAndCloseList(query);
    }

    public List<ConfigProperty> getConfigProperties() {
        Query query = this.pm.newQuery(ConfigProperty.class);
        query.setOrdering("groupName asc, propertyName asc");
        return this.executeAndCloseList(query);
    }

    public ConfigProperty createConfigProperty(String groupName, String propertyName, String propertyValue, IConfigProperty.PropertyType propertyType, String description) {
        return this.callInTransaction(() -> {
            ConfigProperty configProperty = new ConfigProperty();
            configProperty.setGroupName(groupName);
            configProperty.setPropertyName(propertyName);
            configProperty.setPropertyValue(propertyValue);
            configProperty.setPropertyType(propertyType);
            configProperty.setDescription(description);
            return (ConfigProperty)this.pm.makePersistent((Object)configProperty);
        });
    }
}

