/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import javax.jdo.PersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManager;

public class ScopedCustomization
implements AutoCloseable {
    private final JDOPersistenceManager pm;
    private final Deque<Runnable> cleanUpItems = new ArrayDeque<Runnable>();

    public ScopedCustomization(PersistenceManager pm) {
        JDOPersistenceManager jdoPm;
        if (!(pm instanceof JDOPersistenceManager)) {
            throw new IllegalArgumentException("Unsupported PersistenceManager type: %s".formatted(pm.getClass().getName()));
        }
        this.pm = jdoPm = (JDOPersistenceManager)pm;
    }

    public ScopedCustomization withDetachmentOptions(int detachmentOptions) {
        int originalOptions = this.pm.getFetchPlan().getDetachmentOptions();
        this.cleanUpItems.add(() -> this.pm.getFetchPlan().setDetachmentOptions(originalOptions));
        this.pm.getFetchPlan().setDetachmentOptions(detachmentOptions);
        return this;
    }

    public ScopedCustomization withFetchGroup(String fetchGroup) {
        Set originalFetchGroups = this.pm.getFetchPlan().getGroups();
        this.cleanUpItems.add(() -> this.pm.getFetchPlan().setGroups((Collection)originalFetchGroups));
        this.pm.getFetchPlan().setGroups(new String[]{fetchGroup});
        return this;
    }

    public ScopedCustomization withProperty(String name, String value) {
        Object originalValue = this.pm.getExecutionContext().getProperty(name);
        this.cleanUpItems.add(() -> this.pm.setProperty(name, originalValue));
        this.pm.setProperty(name, (Object)value);
        return this;
    }

    @Override
    public void close() {
        this.cleanUpItems.forEach(Runnable::run);
    }
}

