/*
 * Decompiled with CFR 0.152.
 */
package alpine.security;

import alpine.Config;
import java.security.SecureRandom;

public final class ApiKeyGenerator {
    private static final char[] VALID_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456879".toCharArray();

    private ApiKeyGenerator() {
    }

    public static String generate() {
        return ApiKeyGenerator.generate(32);
    }

    public static String generate(int chars) {
        SecureRandom secureRandom = new SecureRandom();
        char[] buff = new char[chars];
        for (int i = 0; i < chars; ++i) {
            if (i % 10 == 0) {
                secureRandom.setSeed(secureRandom.nextLong());
            }
            buff[i] = VALID_CHARACTERS[secureRandom.nextInt(VALID_CHARACTERS.length)];
        }
        return ApiKeyGenerator.getApiKeyPrefix() + String.valueOf(buff);
    }

    private static String getApiKeyPrefix() {
        return Config.getInstance().getProperty((Config.Key)Config.AlpineKey.API_KEY_PREFIX);
    }
}

