/*
 * Decompiled with CFR 0.152.
 */
package alpine.event.framework;

import alpine.common.logging.Logger;
import alpine.common.metrics.Metrics;
import alpine.common.util.ThreadUtil;
import alpine.event.framework.BaseEventService;
import alpine.event.framework.LoggableUncaughtExceptionHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public final class EventService
extends BaseEventService {
    private static final EventService INSTANCE = new EventService();
    private static final Logger LOGGER = Logger.getLogger(EventService.class);
    private static final ExecutorService EXECUTOR;
    private static final String EXECUTOR_NAME = "Alpine-EventService";

    private EventService() {
    }

    public static EventService getInstance() {
        return INSTANCE;
    }

    static {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("Alpine-EventService-%d").uncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggableUncaughtExceptionHandler()).build();
        int threadPoolSize = ThreadUtil.determineNumberOfWorkerThreads();
        EXECUTOR = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)factory);
        INSTANCE.setExecutorService(EXECUTOR);
        INSTANCE.setLogger(LOGGER);
        Metrics.registerExecutorService((ExecutorService)EXECUTOR, (String)EXECUTOR_NAME);
    }
}

