/*
 * Decompiled with CFR 0.152.
 */
package alpine.persistence;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.jdo.PersistenceManager;

public final class Transaction {
    private Transaction() {
    }

    public static Options defaultOptions() {
        return new Options();
    }

    /*
     * Loose catch block
     */
    public static <T> T call(PersistenceManager pm, Options options, Callable<T> callable) {
        javax.jdo.Transaction jdoTransaction = pm.currentTransaction();
        ArrayList<Runnable> cleanups = new ArrayList<Runnable>();
        try {
            T t;
            boolean isJoiningExisting = jdoTransaction.isActive();
            if (isJoiningExisting && options.propagation == Propagation.REQUIRES_NEW) {
                throw new IllegalStateException("Propagation is set to %s, but a transaction is already active".formatted(new Object[]{Propagation.REQUIRES_NEW}));
            }
            Isolation currentIsolation = Isolation.fromJdoName(jdoTransaction.getIsolationLevel());
            Isolation requestedIsolation = options.isolation;
            if (requestedIsolation != null && currentIsolation != requestedIsolation) {
                if (isJoiningExisting) {
                    throw new IllegalStateException("Requested isolation is %s, but transaction is already active with isolation %s".formatted(new Object[]{requestedIsolation, currentIsolation}));
                }
                cleanups.add(() -> jdoTransaction.setIsolationLevel(currentIsolation.jdoName()));
                jdoTransaction.setIsolationLevel(requestedIsolation.jdoName());
            }
            Boolean currentSerializeRead = jdoTransaction.getSerializeRead();
            Boolean requestedSerializeRead = options.serializeRead;
            if (requestedSerializeRead != null && currentSerializeRead != requestedSerializeRead) {
                if (isJoiningExisting) {
                    throw new IllegalStateException("Requested serializeRead=%s, but transaction is already active with serializeRead=%s".formatted(requestedSerializeRead, currentSerializeRead));
                }
                cleanups.add(() -> jdoTransaction.setSerializeRead(currentSerializeRead));
                jdoTransaction.setSerializeRead(requestedSerializeRead);
            }
            try {
                if (!isJoiningExisting) {
                    jdoTransaction.begin();
                }
                T result = callable.call();
                if (!isJoiningExisting) {
                    jdoTransaction.commit();
                }
                t = result;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)e;
                    throw re;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (jdoTransaction.isActive() && !isJoiningExisting) {
                    jdoTransaction.rollback();
                }
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            cleanups.forEach(Runnable::run);
        }
    }

    public static class Options {
        private Isolation isolation;
        private Propagation propagation;
        private Boolean serializeRead;

        public Options withIsolation(Isolation isolation) {
            this.isolation = isolation;
            return this;
        }

        public Options withPropagation(Propagation propagation) {
            this.propagation = propagation;
            return this;
        }

        public Options withSerializeRead(boolean serializeRead) {
            this.serializeRead = serializeRead;
            return this;
        }
    }

    public static enum Propagation {
        REQUIRED,
        REQUIRES_NEW;

    }

    public static enum Isolation {
        READ_UNCOMMITTED,
        READ_COMMITTED,
        REPEATABLE_READ,
        SNAPSHOT,
        SERIALIZABLE;


        private String jdoName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "read-uncommitted";
                case 1 -> "read-committed";
                case 2 -> "repeatable-read";
                case 3 -> "snapshot";
                case 4 -> "serializable";
            };
        }

        private static Isolation fromJdoName(String jdoName) {
            return switch (jdoName) {
                case "read-uncommitted" -> READ_UNCOMMITTED;
                case "read-committed" -> READ_COMMITTED;
                case "repeatable-read" -> REPEATABLE_READ;
                case "snapshot" -> SNAPSHOT;
                case "serializable" -> SERIALIZABLE;
                default -> throw new IllegalArgumentException("Unknown isolation: %s".formatted(jdoName));
            };
        }
    }
}

