/*
 * Decompiled with CFR 0.152.
 */
package alpine.security;

import alpine.model.ApiKey;
import alpine.security.ApiKeyGenerator;
import alpine.security.InvalidApiKeyFormatException;

public final class ApiKeyDecoder {
    private ApiKeyDecoder() {
    }

    public static ApiKey decode(String apiKeyString) {
        if (apiKeyString == null) {
            throw new InvalidApiKeyFormatException("Provided API key is null");
        }
        ApiKey apiKey = new ApiKey();
        apiKey.setKey(apiKeyString);
        if (apiKeyString.length() == 32) {
            apiKey.setPublicId(apiKeyString.substring(0, 5));
            apiKey.setSecret(apiKeyString.substring(5));
            apiKey.setSecretHash(ApiKeyGenerator.hashSecret(apiKey.getSecret()));
            apiKey.setLegacy(true);
            return apiKey;
        }
        if (apiKeyString.length() == ApiKey.LEGACY_WITH_PREFIX_FULL_KEY_LENGTH) {
            apiKey.setPublicId(apiKeyString.substring(ApiKey.PREFIX_LENGTH, ApiKey.PREFIX_LENGTH + 5));
            apiKey.setSecret(apiKeyString.substring(ApiKey.PREFIX_LENGTH + 5));
            apiKey.setSecretHash(ApiKeyGenerator.hashSecret(apiKey.getSecret()));
            apiKey.setLegacy(true);
            return apiKey;
        }
        String[] parts = apiKeyString.split(String.valueOf('_'));
        if (parts.length != 3) {
            throw new InvalidApiKeyFormatException("Expected exactly 3 parts, but got " + parts.length);
        }
        if (parts[1].length() != 8 && parts[1].length() != 5) {
            throw new InvalidApiKeyFormatException("Expected public ID of %d or %d characters, but got %d".formatted(8, 5, parts[1].length()));
        }
        if (parts[2].length() != 32 && parts[2].length() != 27) {
            throw new InvalidApiKeyFormatException("Expected secret of %d or %d characters, but got %d".formatted(32, 27, parts[2].length()));
        }
        apiKey.setPublicId(parts[1]);
        apiKey.setSecret(parts[2]);
        apiKey.setSecretHash(ApiKeyGenerator.hashSecret(parts[2]));
        return apiKey;
    }
}

