/*
 * Decompiled with CFR 0.152.
 */
package alpine.security;

import alpine.model.ApiKey;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HexFormat;
import java.util.Objects;

public final class ApiKeyGenerator {
    private static final char[] VALID_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456879".toCharArray();

    private ApiKeyGenerator() {
    }

    public static ApiKey generate(String publicId) {
        if (publicId != null && publicId.length() != 8 && publicId.length() != 5) {
            throw new IllegalArgumentException("Expected provided public ID %s to be null or having length of %d or %d, but has length of %d".formatted(publicId, 8, 5, publicId.length()));
        }
        String prefix = ApiKey.PREFIX.replaceAll("_*$", "");
        publicId = Objects.requireNonNullElseGet(publicId, () -> ApiKeyGenerator.generateSecret(8));
        String plainTextSecret = ApiKeyGenerator.generateSecret(32);
        String secretHash = ApiKeyGenerator.hashSecret(plainTextSecret);
        String fullKey = String.join((CharSequence)String.valueOf('_'), prefix, publicId, plainTextSecret);
        ApiKey apiKey = new ApiKey();
        apiKey.setPublicId(publicId);
        apiKey.setSecret(plainTextSecret);
        apiKey.setSecretHash(secretHash);
        apiKey.setKey(fullKey);
        return apiKey;
    }

    public static ApiKey generate() {
        return ApiKeyGenerator.generate(null);
    }

    public static String generateSecret(int secretLength) {
        SecureRandom secureRandom = new SecureRandom();
        char[] buff = new char[secretLength];
        for (int i = 0; i < secretLength; ++i) {
            if (i % 10 == 0) {
                secureRandom.setSeed(secureRandom.nextLong());
            }
            buff[i] = VALID_CHARACTERS[secureRandom.nextInt(VALID_CHARACTERS.length)];
        }
        return String.valueOf(buff);
    }

    public static String hashSecret(String plainTextSecret) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA3-256");
            byte[] secretHash = digest.digest(plainTextSecret.getBytes(StandardCharsets.UTF_8));
            return HexFormat.of().formatHex(secretHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

