/*
 * Decompiled with CFR 0.152.
 */
package alpine.model;

import alpine.model.Permission;
import alpine.model.Team;
import alpine.model.UserPrincipal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Element;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.Order;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

@PersistenceCapable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LdapUser
implements Serializable,
Principal,
UserPrincipal,
Persistable {
    private static final long serialVersionUID = 261924579887470488L;
    @PrimaryKey
    @Persistent(valueStrategy=IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;
    @Persistent
    @Unique(name="LDAPUSER_USERNAME_IDX")
    @Column(name="USERNAME")
    @NotBlank
    @Size(min=1, max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The username must not contain control characters")
    private @NotBlank @Size(min=1, max=255) @Pattern(regexp="[\\P{Cc}]+", message="The username must not contain control characters") String username;
    @Persistent
    @Column(name="DN", allowsNull="false")
    @NotBlank
    @Size(min=1, max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The distinguished name must not contain control characters")
    private @NotBlank @Size(min=1, max=255) @Pattern(regexp="[\\P{Cc}]+", message="The distinguished name must not contain control characters") String dn;
    @Persistent(table="LDAPUSERS_TEAMS", defaultFetchGroup="true")
    @Join(column="LDAPUSER_ID")
    @Element(column="TEAM_ID")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    private List<Team> teams;
    @Size(max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The email address must not contain control characters")
    private transient @Size(max=255) @Pattern(regexp="[\\P{Cc}]+", message="The email address must not contain control characters") String email;
    @Persistent(table="LDAPUSERS_PERMISSIONS", defaultFetchGroup="true")
    @Join(column="LDAPUSER_ID")
    @Element(column="PERMISSION_ID")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    private List<Permission> permissions;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = LdapUser.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = LdapUser.__dnGetInheritedFieldCount();

    @Override
    public long getId() {
        return LdapUser.dnGetid(this);
    }

    @Override
    public void setId(long id) {
        LdapUser.dnSetid(this, id);
    }

    public String getDN() {
        return LdapUser.dnGetdn(this);
    }

    public void setDN(String dn) {
        LdapUser.dnSetdn(this, dn);
    }

    @Override
    public String getUsername() {
        return LdapUser.dnGetusername(this);
    }

    @Override
    public void setUsername(String username) {
        LdapUser.dnSetusername(this, username);
    }

    @Override
    public List<Team> getTeams() {
        return LdapUser.dnGetteams(this);
    }

    @Override
    public void setTeams(List<Team> teams) {
        LdapUser.dnSetteams(this, teams);
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public List<Permission> getPermissions() {
        return LdapUser.dnGetpermissions(this);
    }

    @Override
    public void setPermissions(List<Permission> permissions) {
        LdapUser.dnSetpermissions(this, permissions);
    }

    @Override
    @Deprecated
    @JsonIgnore
    public String getName() {
        return this.getUsername();
    }

    static {
        EnhancementHelper.registerClass((Class)LdapUser.___dn$loadClass("alpine.model.LdapUser"), (Persistable)new LdapUser());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(1, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        LdapUser result = new LdapUser();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        LdapUser result = new LdapUser();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dn = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.permissions = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.teams = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.username = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.dn);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.permissions);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.teams);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.username);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(LdapUser obj, int index) {
        switch (index) {
            case 0: {
                this.dn = obj.dn;
                break;
            }
            case 1: {
                this.id = obj.id;
                break;
            }
            case 2: {
                this.permissions = obj.permissions;
                break;
            }
            case 3: {
                this.teams = obj.teams;
                break;
            }
            case 4: {
                this.username = obj.username;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof LdapUser)) {
            throw new IllegalArgumentException("object is not an object of type alpine.model.LdapUser");
        }
        LdapUser other = (LdapUser)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"dn", "id", "permissions", "teams", "username"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 5;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dnPreSerialize();
        out.defaultWriteObject();
    }

    private static String dnGetdn(LdapUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.dn);
        }
        return objPC.dn;
    }

    private static void dnSetdn(LdapUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.dn, val);
        } else {
            objPC.dn = val;
        }
    }

    private static long dnGetid(LdapUser objPC) {
        return objPC.id;
    }

    private static void dnSetid(LdapUser objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1, objPC.id, val);
        }
    }

    private static List dnGetpermissions(LdapUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, objPC.permissions);
        }
        return objPC.permissions;
    }

    private static void dnSetpermissions(LdapUser objPC, List val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, objPC.permissions, (Object)val);
        } else {
            objPC.permissions = val;
        }
    }

    private static List dnGetteams(LdapUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, objPC.teams);
        }
        return objPC.teams;
    }

    private static void dnSetteams(LdapUser objPC, List val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, objPC.teams, (Object)val);
        } else {
            objPC.teams = val;
        }
    }

    private static String dnGetusername(LdapUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.username);
        }
        return objPC.username;
    }

    private static void dnSetusername(LdapUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.username, val);
        } else {
            objPC.username = val;
        }
    }
}

