/*
 * Decompiled with CFR 0.152.
 */
package alpine.model;

import alpine.model.ApiKey;
import alpine.model.LdapUser;
import alpine.model.ManagedUser;
import alpine.model.MappedLdapGroup;
import alpine.model.MappedOidcGroup;
import alpine.model.OidcUser;
import alpine.model.Permission;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Element;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.FetchGroups;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.Order;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

@PersistenceCapable
@FetchGroups(value={@javax.jdo.annotations.FetchGroup(name="ALL", members={@Persistent(name="uuid"), @Persistent(name="name"), @Persistent(name="apiKeys"), @Persistent(name="ldapUsers"), @Persistent(name="managedUsers"), @Persistent(name="oidcUsers"), @Persistent(name="mappedLdapGroups"), @Persistent(name="mappedOidcGroups"), @Persistent(name="permissions")})})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Team
implements Serializable,
Persistable {
    private static final long serialVersionUID = 6938424919898277944L;
    @PrimaryKey
    @Persistent(valueStrategy=IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;
    @Persistent(customValueStrategy="uuid")
    @Unique(name="TEAM_UUID_IDX")
    @Column(name="UUID", jdbcType="VARCHAR", length=36, allowsNull="false")
    @NotNull
    private UUID uuid;
    @Persistent
    @Column(name="NAME", jdbcType="VARCHAR", length=50, allowsNull="false")
    @NotBlank
    @Size(min=1, max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The team name must not contain control characters")
    private @NotBlank @Size(min=1, max=255) @Pattern(regexp="[\\P{Cc}]+", message="The team name must not contain control characters") String name;
    @Persistent(mappedBy="teams")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="id ASC")})
    private List<ApiKey> apiKeys;
    @Persistent(mappedBy="teams")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="username ASC")})
    private List<LdapUser> ldapUsers;
    @Persistent(mappedBy="teams")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="username ASC")})
    private List<ManagedUser> managedUsers;
    @Persistent(mappedBy="teams")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="username ASC")})
    private List<OidcUser> oidcUsers;
    @Persistent(mappedBy="team")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="dn ASC")})
    private List<MappedLdapGroup> mappedLdapGroups;
    @Persistent(mappedBy="team")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="id ASC")})
    private List<MappedOidcGroup> mappedOidcGroups;
    @Persistent(table="TEAMS_PERMISSIONS", defaultFetchGroup="true")
    @Join(column="TEAM_ID")
    @Element(column="PERMISSION_ID")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    private List<Permission> permissions;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = Team.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Team.__dnGetInheritedFieldCount();

    public long getId() {
        return Team.dnGetid(this);
    }

    public void setId(long id) {
        Team.dnSetid(this, id);
    }

    public UUID getUuid() {
        return Team.dnGetuuid(this);
    }

    public void setUuid(UUID uuid) {
        Team.dnSetuuid(this, uuid);
    }

    public String getName() {
        return Team.dnGetname(this);
    }

    public void setName(String name) {
        Team.dnSetname(this, name);
    }

    public List<ApiKey> getApiKeys() {
        return Team.dnGetapiKeys(this);
    }

    public void setApiKeys(List<ApiKey> apiKeys) {
        Team.dnSetapiKeys(this, apiKeys);
    }

    public List<LdapUser> getLdapUsers() {
        return Team.dnGetldapUsers(this);
    }

    public void setLdapUsers(List<LdapUser> ldapUsers) {
        Team.dnSetldapUsers(this, ldapUsers);
    }

    public List<ManagedUser> getManagedUsers() {
        return Team.dnGetmanagedUsers(this);
    }

    public void setManagedUsers(List<ManagedUser> managedUsers) {
        Team.dnSetmanagedUsers(this, managedUsers);
    }

    public List<OidcUser> getOidcUsers() {
        return Team.dnGetoidcUsers(this);
    }

    public void setOidcUsers(List<OidcUser> oidcUsers) {
        Team.dnSetoidcUsers(this, oidcUsers);
    }

    public List<MappedLdapGroup> getMappedLdapGroups() {
        return Team.dnGetmappedLdapGroups(this);
    }

    public void setMappedLdapGroups(List<MappedLdapGroup> mappedLdapGroups) {
        Team.dnSetmappedLdapGroups(this, mappedLdapGroups);
    }

    public List<MappedOidcGroup> getMappedOidcGroups() {
        return Team.dnGetmappedOidcGroups(this);
    }

    public void setMappedOidcGroups(List<MappedOidcGroup> mappedOidcGroups) {
        Team.dnSetmappedOidcGroups(this, mappedOidcGroups);
    }

    public List<Permission> getPermissions() {
        return Team.dnGetpermissions(this);
    }

    public void setPermissions(List<Permission> permissions) {
        Team.dnSetpermissions(this, permissions);
    }

    static {
        EnhancementHelper.registerClass((Class)Team.___dn$loadClass("alpine.model.Team"), (Persistable)new Team());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(1, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Team result = new Team();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Team result = new Team();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.apiKeys = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.ldapUsers = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.managedUsers = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.mappedLdapGroups = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.mappedOidcGroups = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.oidcUsers = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.permissions = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 9: {
                this.uuid = (UUID)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.apiKeys);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.ldapUsers);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.managedUsers);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.mappedLdapGroups);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.mappedOidcGroups);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.oidcUsers);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.permissions);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.uuid);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(Team obj, int index) {
        switch (index) {
            case 0: {
                this.apiKeys = obj.apiKeys;
                break;
            }
            case 1: {
                this.id = obj.id;
                break;
            }
            case 2: {
                this.ldapUsers = obj.ldapUsers;
                break;
            }
            case 3: {
                this.managedUsers = obj.managedUsers;
                break;
            }
            case 4: {
                this.mappedLdapGroups = obj.mappedLdapGroups;
                break;
            }
            case 5: {
                this.mappedOidcGroups = obj.mappedOidcGroups;
                break;
            }
            case 6: {
                this.name = obj.name;
                break;
            }
            case 7: {
                this.oidcUsers = obj.oidcUsers;
                break;
            }
            case 8: {
                this.permissions = obj.permissions;
                break;
            }
            case 9: {
                this.uuid = obj.uuid;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Team)) {
            throw new IllegalArgumentException("object is not an object of type alpine.model.Team");
        }
        Team other = (Team)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"apiKeys", "id", "ldapUsers", "managedUsers", "mappedLdapGroups", "mappedOidcGroups", "name", "oidcUsers", "permissions", "uuid"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 10;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dnPreSerialize();
        out.defaultWriteObject();
    }

    private static List dnGetapiKeys(Team objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, objPC.apiKeys);
        }
        return objPC.apiKeys;
    }

    private static void dnSetapiKeys(Team objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.apiKeys = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, objPC.apiKeys, (Object)val);
        }
    }

    private static long dnGetid(Team objPC) {
        return objPC.id;
    }

    private static void dnSetid(Team objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1, objPC.id, val);
        }
    }

    private static List dnGetldapUsers(Team objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, objPC.ldapUsers);
        }
        return objPC.ldapUsers;
    }

    private static void dnSetldapUsers(Team objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.ldapUsers = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, objPC.ldapUsers, (Object)val);
        }
    }

    private static List dnGetmanagedUsers(Team objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, objPC.managedUsers);
        }
        return objPC.managedUsers;
    }

    private static void dnSetmanagedUsers(Team objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.managedUsers = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, objPC.managedUsers, (Object)val);
        }
    }

    private static List dnGetmappedLdapGroups(Team objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, objPC.mappedLdapGroups);
        }
        return objPC.mappedLdapGroups;
    }

    private static void dnSetmappedLdapGroups(Team objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.mappedLdapGroups = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, objPC.mappedLdapGroups, (Object)val);
        }
    }

    private static List dnGetmappedOidcGroups(Team objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 5, objPC.mappedOidcGroups);
        }
        return objPC.mappedOidcGroups;
    }

    private static void dnSetmappedOidcGroups(Team objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.mappedOidcGroups = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5, objPC.mappedOidcGroups, (Object)val);
        }
    }

    private static String dnGetname(Team objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(Team objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static List dnGetoidcUsers(Team objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 7, objPC.oidcUsers);
        }
        return objPC.oidcUsers;
    }

    private static void dnSetoidcUsers(Team objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.oidcUsers = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, objPC.oidcUsers, (Object)val);
        }
    }

    private static List dnGetpermissions(Team objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 8, objPC.permissions);
        }
        return objPC.permissions;
    }

    private static void dnSetpermissions(Team objPC, List val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8, objPC.permissions, (Object)val);
        } else {
            objPC.permissions = val;
        }
    }

    private static UUID dnGetuuid(Team objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return (UUID)objPC.dnStateManager.getObjectField((Persistable)objPC, 9, (Object)objPC.uuid);
        }
        return objPC.uuid;
    }

    private static void dnSetuuid(Team objPC, UUID val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, (Object)objPC.uuid, (Object)val);
        } else {
            objPC.uuid = val;
        }
    }

    public static enum FetchGroup {
        ALL;

    }
}

