/*
 * Decompiled with CFR 0.152.
 */
package alpine.model;

import alpine.Config;
import alpine.model.Team;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Element;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.Order;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

@PersistenceCapable
public class ApiKey
implements Serializable,
Principal,
Persistable {
    private static final long serialVersionUID = 1582714693932260365L;
    private static final String prefix = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.API_KEY_PREFIX);
    @PrimaryKey
    @Persistent(valueStrategy=IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;
    @Persistent
    @Unique(name="APIKEY_IDX")
    @Column(name="APIKEY", allowsNull="false")
    @NotNull
    @Size(min=32, max=255)
    @Pattern(regexp="^[a-zA-Z_0-9]*$", message="The API key must contain only alpha, numeric and/or underscore characters")
    private @NotNull @Size(min=32, max=255) @Pattern(regexp="^[a-zA-Z_0-9]*$", message="The API key must contain only alpha, numeric and/or underscore characters") String key;
    @Persistent(table="APIKEYS_TEAMS", defaultFetchGroup="true")
    @Join(column="APIKEY_ID")
    @Element(column="TEAM_ID")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    @JsonIgnore
    private List<Team> teams;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = ApiKey.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = ApiKey.__dnGetInheritedFieldCount();

    public long getId() {
        return ApiKey.dnGetid(this);
    }

    public void setId(long id) {
        ApiKey.dnSetid(this, id);
    }

    public String getKey() {
        return ApiKey.dnGetkey(this);
    }

    public void setKey(String key) {
        ApiKey.dnSetkey(this, key);
    }

    public String getMaskedKey() {
        StringBuilder maskedKey = new StringBuilder();
        if (ApiKey.dnGetkey(this).startsWith(prefix)) {
            maskedKey.append(prefix);
        }
        maskedKey.append("*".repeat(ApiKey.dnGetkey(this).length() - maskedKey.length() - 4));
        maskedKey.append(ApiKey.dnGetkey(this).substring(ApiKey.dnGetkey(this).length() - 4));
        return maskedKey.toString();
    }

    @Override
    @Deprecated
    @JsonIgnore
    public String getName() {
        return this.getMaskedKey();
    }

    public List<Team> getTeams() {
        return ApiKey.dnGetteams(this);
    }

    public void setTeams(List<Team> teams) {
        ApiKey.dnSetteams(this, teams);
    }

    static {
        EnhancementHelper.registerClass((Class)ApiKey.___dn$loadClass("alpine.model.ApiKey"), (Persistable)new ApiKey());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(0, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        ApiKey result = new ApiKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        ApiKey result = new ApiKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.key = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.teams = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.key);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.teams);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(ApiKey obj, int index) {
        switch (index) {
            case 0: {
                this.id = obj.id;
                break;
            }
            case 1: {
                this.key = obj.key;
                break;
            }
            case 2: {
                this.teams = obj.teams;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof ApiKey)) {
            throw new IllegalArgumentException("object is not an object of type alpine.model.ApiKey");
        }
        ApiKey other = (ApiKey)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"id", "key", "teams"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 3;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dnPreSerialize();
        out.defaultWriteObject();
    }

    private static long dnGetid(ApiKey objPC) {
        return objPC.id;
    }

    private static void dnSetid(ApiKey objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0, objPC.id, val);
        }
    }

    private static String dnGetkey(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.key);
        }
        return objPC.key;
    }

    private static void dnSetkey(ApiKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.key, val);
        } else {
            objPC.key = val;
        }
    }

    private static List dnGetteams(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, objPC.teams);
        }
        return objPC.teams;
    }

    private static void dnSetteams(ApiKey objPC, List val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, objPC.teams, (Object)val);
        } else {
            objPC.teams = val;
        }
    }
}

