/*
 * Decompiled with CFR 0.152.
 */
package alpine.model;

import alpine.model.Team;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.UUID;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

@PersistenceCapable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Unique(members={"team", "dn"})
public class MappedLdapGroup
implements Serializable,
Persistable {
    @PrimaryKey
    @Persistent(valueStrategy=IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;
    @Persistent(defaultFetchGroup="true")
    @Column(name="TEAM_ID", allowsNull="false")
    @JsonIgnore
    private Team team;
    @Persistent
    @Column(name="DN", jdbcType="VARCHAR", length=1024, allowsNull="false")
    @NotBlank
    @Size(min=1, max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The distinguished name must not contain control characters")
    private @NotBlank @Size(min=1, max=255) @Pattern(regexp="[\\P{Cc}]+", message="The distinguished name must not contain control characters") String dn;
    @Persistent(customValueStrategy="uuid")
    @Unique(name="MAPPEDLDAPGROUP_UUID_IDX")
    @Column(name="UUID", jdbcType="VARCHAR", length=36, allowsNull="false")
    @NotNull
    private UUID uuid;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = MappedLdapGroup.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = MappedLdapGroup.__dnGetInheritedFieldCount();
    private static final long serialVersionUID = -595478212957736258L;

    public long getId() {
        return MappedLdapGroup.dnGetid(this);
    }

    public void setId(long id) {
        MappedLdapGroup.dnSetid(this, id);
    }

    public Team getTeam() {
        return MappedLdapGroup.dnGetteam(this);
    }

    public void setTeam(Team team) {
        MappedLdapGroup.dnSetteam(this, team);
    }

    public String getDn() {
        return MappedLdapGroup.dnGetdn(this);
    }

    public void setDn(String dn) {
        MappedLdapGroup.dnSetdn(this, dn);
    }

    public UUID getUuid() {
        return MappedLdapGroup.dnGetuuid(this);
    }

    public void setUuid(UUID uuid) {
        MappedLdapGroup.dnSetuuid(this, uuid);
    }

    static {
        EnhancementHelper.registerClass((Class)MappedLdapGroup.___dn$loadClass("alpine.model.MappedLdapGroup"), (Persistable)new MappedLdapGroup());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(1, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        MappedLdapGroup result = new MappedLdapGroup();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        MappedLdapGroup result = new MappedLdapGroup();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dn = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.team = (Team)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.uuid = (UUID)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.dn);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.team);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.uuid);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(MappedLdapGroup obj, int index) {
        switch (index) {
            case 0: {
                this.dn = obj.dn;
                break;
            }
            case 1: {
                this.id = obj.id;
                break;
            }
            case 2: {
                this.team = obj.team;
                break;
            }
            case 3: {
                this.uuid = obj.uuid;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MappedLdapGroup)) {
            throw new IllegalArgumentException("object is not an object of type alpine.model.MappedLdapGroup");
        }
        MappedLdapGroup other = (MappedLdapGroup)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"dn", "id", "team", "uuid"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 4;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dnPreSerialize();
        out.defaultWriteObject();
    }

    private static String dnGetdn(MappedLdapGroup objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.dn);
        }
        return objPC.dn;
    }

    private static void dnSetdn(MappedLdapGroup objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.dn, val);
        } else {
            objPC.dn = val;
        }
    }

    private static long dnGetid(MappedLdapGroup objPC) {
        return objPC.id;
    }

    private static void dnSetid(MappedLdapGroup objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1, objPC.id, val);
        }
    }

    private static Team dnGetteam(MappedLdapGroup objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (Team)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.team);
        }
        return objPC.team;
    }

    private static void dnSetteam(MappedLdapGroup objPC, Team val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.team, (Object)val);
        } else {
            objPC.team = val;
        }
    }

    private static UUID dnGetuuid(MappedLdapGroup objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (UUID)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, (Object)objPC.uuid);
        }
        return objPC.uuid;
    }

    private static void dnSetuuid(MappedLdapGroup objPC, UUID val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, (Object)objPC.uuid, (Object)val);
        } else {
            objPC.uuid = val;
        }
    }
}

