/*
 * Decompiled with CFR 0.152.
 */
package alpine.model;

import alpine.model.LdapUser;
import alpine.model.ManagedUser;
import alpine.model.OidcUser;
import alpine.model.Team;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Order;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

@PersistenceCapable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Permission
implements Serializable,
Persistable {
    private static final long serialVersionUID = 1420020753285692448L;
    @PrimaryKey
    @Persistent(valueStrategy=IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;
    @Persistent
    @Unique(name="PERMISSION_IDX")
    @Column(name="NAME", allowsNull="false")
    @NotBlank
    @Size(min=1, max=255)
    @Pattern(regexp="^[a-zA-Z_0-9]*$", message="The permission name must contain only alpha and/or numeric characters")
    private @NotBlank @Size(min=1, max=255) @Pattern(regexp="^[a-zA-Z_0-9]*$", message="The permission name must contain only alpha and/or numeric characters") String name;
    @Persistent
    @Column(name="DESCRIPTION", jdbcType="CLOB")
    private String description;
    @Persistent(mappedBy="permissions")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    @JsonIgnore
    private List<Team> teams;
    @Persistent(mappedBy="permissions")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="username ASC")})
    @JsonIgnore
    private List<OidcUser> oidcUsers;
    @Persistent(mappedBy="permissions")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="username ASC")})
    @JsonIgnore
    private List<LdapUser> ldapUsers;
    @Persistent(mappedBy="permissions")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="username ASC")})
    @JsonIgnore
    private List<ManagedUser> managedUsers;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = Permission.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Permission.__dnGetInheritedFieldCount();

    public long getId() {
        return Permission.dnGetid(this);
    }

    public void setId(long id) {
        Permission.dnSetid(this, id);
    }

    public String getName() {
        return Permission.dnGetname(this);
    }

    public void setName(String name) {
        Permission.dnSetname(this, name);
    }

    public String getDescription() {
        return Permission.dnGetdescription(this);
    }

    public void setDescription(String description) {
        Permission.dnSetdescription(this, description);
    }

    public List<Team> getTeams() {
        return Permission.dnGetteams(this);
    }

    public void setTeams(List<Team> teams) {
        Permission.dnSetteams(this, teams);
    }

    public List<OidcUser> getOidcUsers() {
        return Permission.dnGetoidcUsers(this);
    }

    public void setOidcUsers(List<OidcUser> oidcUsers) {
        Permission.dnSetoidcUsers(this, oidcUsers);
    }

    public List<LdapUser> getLdapUsers() {
        return Permission.dnGetldapUsers(this);
    }

    public void setLdapUsers(List<LdapUser> ldapUsers) {
        Permission.dnSetldapUsers(this, ldapUsers);
    }

    public List<ManagedUser> getManagedUsers() {
        return Permission.dnGetmanagedUsers(this);
    }

    public void setManagedUsers(List<ManagedUser> managedUsers) {
        Permission.dnSetmanagedUsers(this, managedUsers);
    }

    static {
        EnhancementHelper.registerClass((Class)Permission.___dn$loadClass("alpine.model.Permission"), (Persistable)new Permission());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(1, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Permission result = new Permission();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Permission result = new Permission();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.description = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.ldapUsers = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.managedUsers = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.oidcUsers = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.teams = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.description);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.ldapUsers);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.managedUsers);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.oidcUsers);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.teams);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(Permission obj, int index) {
        switch (index) {
            case 0: {
                this.description = obj.description;
                break;
            }
            case 1: {
                this.id = obj.id;
                break;
            }
            case 2: {
                this.ldapUsers = obj.ldapUsers;
                break;
            }
            case 3: {
                this.managedUsers = obj.managedUsers;
                break;
            }
            case 4: {
                this.name = obj.name;
                break;
            }
            case 5: {
                this.oidcUsers = obj.oidcUsers;
                break;
            }
            case 6: {
                this.teams = obj.teams;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Permission)) {
            throw new IllegalArgumentException("object is not an object of type alpine.model.Permission");
        }
        Permission other = (Permission)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"description", "id", "ldapUsers", "managedUsers", "name", "oidcUsers", "teams"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 7;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dnPreSerialize();
        out.defaultWriteObject();
    }

    private static String dnGetdescription(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.description);
        }
        return objPC.description;
    }

    private static void dnSetdescription(Permission objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.description, val);
        } else {
            objPC.description = val;
        }
    }

    private static long dnGetid(Permission objPC) {
        return objPC.id;
    }

    private static void dnSetid(Permission objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1, objPC.id, val);
        }
    }

    private static List dnGetldapUsers(Permission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, objPC.ldapUsers);
        }
        return objPC.ldapUsers;
    }

    private static void dnSetldapUsers(Permission objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.ldapUsers = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, objPC.ldapUsers, (Object)val);
        }
    }

    private static List dnGetmanagedUsers(Permission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, objPC.managedUsers);
        }
        return objPC.managedUsers;
    }

    private static void dnSetmanagedUsers(Permission objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.managedUsers = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, objPC.managedUsers, (Object)val);
        }
    }

    private static String dnGetname(Permission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(Permission objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static List dnGetoidcUsers(Permission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 5, objPC.oidcUsers);
        }
        return objPC.oidcUsers;
    }

    private static void dnSetoidcUsers(Permission objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.oidcUsers = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5, objPC.oidcUsers, (Object)val);
        }
    }

    private static List dnGetteams(Permission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 6, objPC.teams);
        }
        return objPC.teams;
    }

    private static void dnSetteams(Permission objPC, List val) {
        if (objPC.dnStateManager == null) {
            objPC.teams = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6, objPC.teams, (Object)val);
        }
    }
}

