/*
 * Decompiled with CFR 0.152.
 */
package alpine.model;

import alpine.Config;
import alpine.model.Team;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Element;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.Order;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

@PersistenceCapable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiKey
implements Serializable,
Principal,
Persistable {
    private static final long serialVersionUID = 1582714693932260365L;
    public static final String PREFIX = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.API_KEY_PREFIX);
    public static final int PREFIX_LENGTH = PREFIX.length();
    public static final int PUBLIC_ID_LENGTH = 8;
    public static final int LEGACY_PUBLIC_ID_LENGTH = 5;
    public static final int API_KEY_LENGTH = 32;
    public static final char API_KEY_SEPARATOR = '_';
    public static final int LEGACY_FULL_KEY_LENGTH = 32;
    public static final int LEGACY_WITH_PREFIX_FULL_KEY_LENGTH = PREFIX.length() + 32;
    @PrimaryKey
    @Persistent(valueStrategy=IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;
    @Schema(description="The full, plain-text key. Only set when initially created, or regenerated.", nullable=true)
    private transient String key;
    @JsonIgnore
    private transient String secret;
    @Persistent
    @Column(name="SECRET_HASH", length=64, allowsNull="true")
    @JsonIgnore
    private String secretHash;
    @Persistent
    @Column(name="COMMENT")
    @Size(max=255)
    private @Size(max=255) String comment;
    @Persistent
    @Column(name="CREATED")
    private Date created;
    @Persistent
    @Column(name="LAST_USED")
    private Date lastUsed;
    @Persistent(table="APIKEYS_TEAMS", defaultFetchGroup="true")
    @Join(column="APIKEY_ID")
    @Element(column="TEAM_ID")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    @JsonIgnore
    private List<Team> teams;
    @Persistent
    @Unique(name="APIKEY_PUBLIC_IDX")
    @Size(min=5, max=8)
    @Column(name="PUBLIC_ID", length=8, allowsNull="true")
    private @Size(min=5, max=8) String publicId;
    @Persistent
    @Column(name="IS_LEGACY", allowsNull="false", defaultValue="false")
    private boolean isLegacy = false;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = ApiKey.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = ApiKey.__dnGetInheritedFieldCount();

    public long getId() {
        return ApiKey.dnGetid(this);
    }

    public void setId(long id) {
        ApiKey.dnSetid(this, id);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getSecretHash() {
        return ApiKey.dnGetsecretHash(this);
    }

    public void setSecretHash(String secretHash) {
        ApiKey.dnSetsecretHash(this, secretHash);
    }

    public String getMaskedKey() {
        return PREFIX + ApiKey.dnGetpublicId(this) + "*".repeat(32);
    }

    @Override
    @Deprecated
    @JsonIgnore
    public String getName() {
        return this.getMaskedKey();
    }

    public String getComment() {
        return ApiKey.dnGetcomment(this);
    }

    public void setComment(String comment) {
        ApiKey.dnSetcomment(this, comment);
    }

    public Date getCreated() {
        return ApiKey.dnGetcreated(this);
    }

    public void setCreated(Date created) {
        ApiKey.dnSetcreated(this, created);
    }

    public Date getLastUsed() {
        return ApiKey.dnGetlastUsed(this);
    }

    public void setLastUsed(Date lastUsed) {
        ApiKey.dnSetlastUsed(this, lastUsed);
    }

    public List<Team> getTeams() {
        return ApiKey.dnGetteams(this);
    }

    public void setTeams(List<Team> teams) {
        ApiKey.dnSetteams(this, teams);
    }

    public String getPublicId() {
        return ApiKey.dnGetpublicId(this);
    }

    public void setPublicId(String publicID) {
        ApiKey.dnSetpublicId(this, publicID);
    }

    public boolean isLegacy() {
        return ApiKey.dnGetisLegacy(this);
    }

    public void setLegacy(boolean isLegacy) {
        ApiKey.dnSetisLegacy(this, isLegacy);
    }

    static {
        EnhancementHelper.registerClass((Class)ApiKey.___dn$loadClass("alpine.model.ApiKey"), (Persistable)new ApiKey());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(2, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        ApiKey result = new ApiKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        ApiKey result = new ApiKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.comment = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.created = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 3: {
                this.isLegacy = this.dnStateManager.replacingBooleanField((Persistable)this, index);
                break;
            }
            case 4: {
                this.lastUsed = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.publicId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 6: {
                this.secretHash = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.teams = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.comment);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.created);
                break;
            }
            case 2: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            case 3: {
                this.dnStateManager.providedBooleanField((Persistable)this, index, this.isLegacy);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.lastUsed);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.publicId);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.secretHash);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.teams);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(ApiKey obj, int index) {
        switch (index) {
            case 0: {
                this.comment = obj.comment;
                break;
            }
            case 1: {
                this.created = obj.created;
                break;
            }
            case 2: {
                this.id = obj.id;
                break;
            }
            case 3: {
                this.isLegacy = obj.isLegacy;
                break;
            }
            case 4: {
                this.lastUsed = obj.lastUsed;
                break;
            }
            case 5: {
                this.publicId = obj.publicId;
                break;
            }
            case 6: {
                this.secretHash = obj.secretHash;
                break;
            }
            case 7: {
                this.teams = obj.teams;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof ApiKey)) {
            throw new IllegalArgumentException("object is not an object of type alpine.model.ApiKey");
        }
        ApiKey other = (ApiKey)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"comment", "created", "id", "isLegacy", "lastUsed", "publicId", "secretHash", "teams"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 8;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dnPreSerialize();
        out.defaultWriteObject();
    }

    private static String dnGetcomment(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.comment);
        }
        return objPC.comment;
    }

    private static void dnSetcomment(ApiKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.comment, val);
        } else {
            objPC.comment = val;
        }
    }

    private static Date dnGetcreated(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 1, (Object)objPC.created);
        }
        return objPC.created;
    }

    private static void dnSetcreated(ApiKey objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1, (Object)objPC.created, (Object)val);
        } else {
            objPC.created = val;
        }
    }

    private static long dnGetid(ApiKey objPC) {
        return objPC.id;
    }

    private static void dnSetid(ApiKey objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 2, objPC.id, val);
        }
    }

    private static boolean dnGetisLegacy(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getBooleanField((Persistable)objPC, 3, objPC.isLegacy);
        }
        return objPC.isLegacy;
    }

    private static void dnSetisLegacy(ApiKey objPC, boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setBooleanField((Persistable)objPC, 3, objPC.isLegacy, val);
        } else {
            objPC.isLegacy = val;
        }
    }

    private static Date dnGetlastUsed(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, (Object)objPC.lastUsed);
        }
        return objPC.lastUsed;
    }

    private static void dnSetlastUsed(ApiKey objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, (Object)objPC.lastUsed, (Object)val);
        } else {
            objPC.lastUsed = val;
        }
    }

    private static String dnGetpublicId(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.publicId);
        }
        return objPC.publicId;
    }

    private static void dnSetpublicId(ApiKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.publicId, val);
        } else {
            objPC.publicId = val;
        }
    }

    private static String dnGetsecretHash(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.secretHash);
        }
        return objPC.secretHash;
    }

    private static void dnSetsecretHash(ApiKey objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.secretHash, val);
        } else {
            objPC.secretHash = val;
        }
    }

    private static List dnGetteams(ApiKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 7, objPC.teams);
        }
        return objPC.teams;
    }

    private static void dnSetteams(ApiKey objPC, List val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, objPC.teams, (Object)val);
        } else {
            objPC.teams = val;
        }
    }
}

