/*
 * Decompiled with CFR 0.152.
 */
package alpine.model;

import alpine.model.Permission;
import alpine.model.Team;
import alpine.model.UserPrincipal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Element;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.Order;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Unique;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;

@PersistenceCapable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ManagedUser
implements Serializable,
Principal,
UserPrincipal,
Persistable {
    private static final long serialVersionUID = 7944779964068911025L;
    @PrimaryKey
    @Persistent(valueStrategy=IdGeneratorStrategy.NATIVE)
    @JsonIgnore
    private long id;
    @Persistent
    @Unique(name="MANAGEDUSER_USERNAME_IDX")
    @Column(name="USERNAME")
    @NotBlank
    @Size(min=1, max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The username must not contain control characters")
    private @NotBlank @Size(min=1, max=255) @Pattern(regexp="[\\P{Cc}]+", message="The username must not contain control characters") String username;
    @Persistent
    @Column(name="PASSWORD", allowsNull="false")
    @NotBlank
    @Size(min=1, max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The password must not contain control characters")
    @JsonIgnore
    private @NotBlank @Size(min=1, max=255) @Pattern(regexp="[\\P{Cc}]+", message="The password must not contain control characters") String password;
    @Size(max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The new password must not contain control characters")
    private transient @Size(max=255) @Pattern(regexp="[\\P{Cc}]+", message="The new password must not contain control characters") String newPassword;
    @Size(max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The confirm password must not contain control characters")
    private transient @Size(max=255) @Pattern(regexp="[\\P{Cc}]+", message="The confirm password must not contain control characters") String confirmPassword;
    @Persistent
    @Column(name="LAST_PASSWORD_CHANGE", allowsNull="false")
    @NotNull
    private Date lastPasswordChange;
    @Persistent
    @Column(name="FULLNAME")
    @Size(max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The full name must not contain control characters")
    private @Size(max=255) @Pattern(regexp="[\\P{Cc}]+", message="The full name must not contain control characters") String fullname;
    @Persistent
    @Column(name="EMAIL")
    @Size(max=255)
    @Pattern(regexp="[\\P{Cc}]+", message="The email address must not contain control characters")
    private @Size(max=255) @Pattern(regexp="[\\P{Cc}]+", message="The email address must not contain control characters") String email;
    @Persistent
    @Column(name="SUSPENDED")
    private boolean suspended;
    @Persistent
    @Column(name="FORCE_PASSWORD_CHANGE")
    private boolean forcePasswordChange;
    @Persistent
    @Column(name="NON_EXPIRY_PASSWORD")
    private boolean nonExpiryPassword;
    @Persistent(table="MANAGEDUSERS_TEAMS", defaultFetchGroup="true")
    @Join(column="MANAGEDUSER_ID")
    @Element(column="TEAM_ID")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    private List<Team> teams;
    @Persistent(table="MANAGEDUSERS_PERMISSIONS", defaultFetchGroup="true")
    @Join(column="MANAGEDUSER_ID")
    @Element(column="PERMISSION_ID")
    @Order(extensions={@Extension(vendorName="datanucleus", key="list-ordering", value="name ASC")})
    private List<Permission> permissions;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = ManagedUser.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = ManagedUser.__dnGetInheritedFieldCount();

    @Override
    public long getId() {
        return ManagedUser.dnGetid(this);
    }

    @Override
    public void setId(long id) {
        ManagedUser.dnSetid(this, id);
    }

    @Override
    public String getUsername() {
        return ManagedUser.dnGetusername(this);
    }

    @Override
    public void setUsername(String username) {
        ManagedUser.dnSetusername(this, username);
    }

    public String getPassword() {
        return ManagedUser.dnGetpassword(this);
    }

    public void setPassword(String password) {
        ManagedUser.dnSetpassword(this, password);
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public Date getLastPasswordChange() {
        return ManagedUser.dnGetlastPasswordChange(this);
    }

    public void setLastPasswordChange(Date lastPasswordChange) {
        ManagedUser.dnSetlastPasswordChange(this, lastPasswordChange);
    }

    public String getFullname() {
        return ManagedUser.dnGetfullname(this);
    }

    public void setFullname(String fullname) {
        ManagedUser.dnSetfullname(this, fullname);
    }

    @Override
    public String getEmail() {
        return ManagedUser.dnGetemail(this);
    }

    @Override
    public void setEmail(String email) {
        ManagedUser.dnSetemail(this, email);
    }

    public boolean isSuspended() {
        return ManagedUser.dnGetsuspended(this);
    }

    public void setSuspended(boolean suspended) {
        ManagedUser.dnSetsuspended(this, suspended);
    }

    public boolean isForcePasswordChange() {
        return ManagedUser.dnGetforcePasswordChange(this);
    }

    public void setForcePasswordChange(boolean forcePasswordChange) {
        ManagedUser.dnSetforcePasswordChange(this, forcePasswordChange);
    }

    public boolean isNonExpiryPassword() {
        return ManagedUser.dnGetnonExpiryPassword(this);
    }

    public void setNonExpiryPassword(boolean nonExpiryPassword) {
        ManagedUser.dnSetnonExpiryPassword(this, nonExpiryPassword);
    }

    @Override
    public List<Team> getTeams() {
        return ManagedUser.dnGetteams(this);
    }

    @Override
    public void setTeams(List<Team> teams) {
        ManagedUser.dnSetteams(this, teams);
    }

    @Override
    public List<Permission> getPermissions() {
        return ManagedUser.dnGetpermissions(this);
    }

    @Override
    public void setPermissions(List<Permission> permissions) {
        ManagedUser.dnSetpermissions(this, permissions);
    }

    @Override
    @Deprecated
    @JsonIgnore
    public String getName() {
        return this.getUsername();
    }

    static {
        EnhancementHelper.registerClass((Class)ManagedUser.___dn$loadClass("alpine.model.ManagedUser"), (Persistable)new ManagedUser());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(3, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        ManagedUser result = new ManagedUser();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        ManagedUser result = new ManagedUser();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.email = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.forcePasswordChange = this.dnStateManager.replacingBooleanField((Persistable)this, index);
                break;
            }
            case 2: {
                this.fullname = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.id = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 4: {
                this.lastPasswordChange = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.nonExpiryPassword = this.dnStateManager.replacingBooleanField((Persistable)this, index);
                break;
            }
            case 6: {
                this.password = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.permissions = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.suspended = this.dnStateManager.replacingBooleanField((Persistable)this, index);
                break;
            }
            case 9: {
                this.teams = (List)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 10: {
                this.username = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.email);
                break;
            }
            case 1: {
                this.dnStateManager.providedBooleanField((Persistable)this, index, this.forcePasswordChange);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.fullname);
                break;
            }
            case 3: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.id);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.lastPasswordChange);
                break;
            }
            case 5: {
                this.dnStateManager.providedBooleanField((Persistable)this, index, this.nonExpiryPassword);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.password);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.permissions);
                break;
            }
            case 8: {
                this.dnStateManager.providedBooleanField((Persistable)this, index, this.suspended);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.teams);
                break;
            }
            case 10: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.username);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(ManagedUser obj, int index) {
        switch (index) {
            case 0: {
                this.email = obj.email;
                break;
            }
            case 1: {
                this.forcePasswordChange = obj.forcePasswordChange;
                break;
            }
            case 2: {
                this.fullname = obj.fullname;
                break;
            }
            case 3: {
                this.id = obj.id;
                break;
            }
            case 4: {
                this.lastPasswordChange = obj.lastPasswordChange;
                break;
            }
            case 5: {
                this.nonExpiryPassword = obj.nonExpiryPassword;
                break;
            }
            case 6: {
                this.password = obj.password;
                break;
            }
            case 7: {
                this.permissions = obj.permissions;
                break;
            }
            case 8: {
                this.suspended = obj.suspended;
                break;
            }
            case 9: {
                this.teams = obj.teams;
                break;
            }
            case 10: {
                this.username = obj.username;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof ManagedUser)) {
            throw new IllegalArgumentException("object is not an object of type alpine.model.ManagedUser");
        }
        ManagedUser other = (ManagedUser)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"email", "forcePasswordChange", "fullname", "id", "lastPasswordChange", "nonExpiryPassword", "password", "permissions", "suspended", "teams", "username"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 11;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dnPreSerialize();
        out.defaultWriteObject();
    }

    private static String dnGetemail(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.email);
        }
        return objPC.email;
    }

    private static void dnSetemail(ManagedUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.email, val);
        } else {
            objPC.email = val;
        }
    }

    private static boolean dnGetforcePasswordChange(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getBooleanField((Persistable)objPC, 1, objPC.forcePasswordChange);
        }
        return objPC.forcePasswordChange;
    }

    private static void dnSetforcePasswordChange(ManagedUser objPC, boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setBooleanField((Persistable)objPC, 1, objPC.forcePasswordChange, val);
        } else {
            objPC.forcePasswordChange = val;
        }
    }

    private static String dnGetfullname(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2, objPC.fullname);
        }
        return objPC.fullname;
    }

    private static void dnSetfullname(ManagedUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2, objPC.fullname, val);
        } else {
            objPC.fullname = val;
        }
    }

    private static long dnGetid(ManagedUser objPC) {
        return objPC.id;
    }

    private static void dnSetid(ManagedUser objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 3, objPC.id, val);
        }
    }

    private static Date dnGetlastPasswordChange(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, (Object)objPC.lastPasswordChange);
        }
        return objPC.lastPasswordChange;
    }

    private static void dnSetlastPasswordChange(ManagedUser objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, (Object)objPC.lastPasswordChange, (Object)val);
        } else {
            objPC.lastPasswordChange = val;
        }
    }

    private static boolean dnGetnonExpiryPassword(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getBooleanField((Persistable)objPC, 5, objPC.nonExpiryPassword);
        }
        return objPC.nonExpiryPassword;
    }

    private static void dnSetnonExpiryPassword(ManagedUser objPC, boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setBooleanField((Persistable)objPC, 5, objPC.nonExpiryPassword, val);
        } else {
            objPC.nonExpiryPassword = val;
        }
    }

    private static String dnGetpassword(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.password);
        }
        return objPC.password;
    }

    private static void dnSetpassword(ManagedUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.password, val);
        } else {
            objPC.password = val;
        }
    }

    private static List dnGetpermissions(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 7, objPC.permissions);
        }
        return objPC.permissions;
    }

    private static void dnSetpermissions(ManagedUser objPC, List val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, objPC.permissions, (Object)val);
        } else {
            objPC.permissions = val;
        }
    }

    private static boolean dnGetsuspended(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return objPC.dnStateManager.getBooleanField((Persistable)objPC, 8, objPC.suspended);
        }
        return objPC.suspended;
    }

    private static void dnSetsuspended(ManagedUser objPC, boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setBooleanField((Persistable)objPC, 8, objPC.suspended, val);
        } else {
            objPC.suspended = val;
        }
    }

    private static List dnGetteams(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return (List)objPC.dnStateManager.getObjectField((Persistable)objPC, 9, objPC.teams);
        }
        return objPC.teams;
    }

    private static void dnSetteams(ManagedUser objPC, List val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, objPC.teams, (Object)val);
        } else {
            objPC.teams = val;
        }
    }

    private static String dnGetusername(ManagedUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 10, objPC.username);
        }
        return objPC.username;
    }

    private static void dnSetusername(ManagedUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 10, objPC.username, val);
        } else {
            objPC.username = val;
        }
    }
}

