/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import alpine.common.logging.Logger;
import alpine.model.ApiKey;
import alpine.model.LdapUser;
import alpine.model.ManagedUser;
import alpine.model.OidcUser;
import alpine.model.UserPrincipal;
import alpine.persistence.AlpineQueryManager;
import alpine.server.auth.PermissionRequired;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;
import org.owasp.security.logging.SecurityMarkers;

@Priority(value=2000)
public class AuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(AuthorizationFilter.class);
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        if (requestContext instanceof ContainerRequest) {
            Principal principal = (Principal)requestContext.getProperty("Principal");
            if (principal == null) {
                LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "A request was made without the assertion of a valid user principal");
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            PermissionRequired annotation = this.resourceInfo.getResourceMethod().getDeclaredAnnotation(PermissionRequired.class);
            String[] permissions = annotation.value();
            try (AlpineQueryManager qm = new AlpineQueryManager();){
                if (principal instanceof ApiKey) {
                    ApiKey apiKey = (ApiKey)principal;
                    for (String permission : permissions) {
                        if (!qm.hasPermission(apiKey, permission)) continue;
                        return;
                    }
                    String maskedApiKey = apiKey.getKey().replaceAll("\\w(?=\\w{4})", "*");
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Unauthorized access attempt made by API Key " + maskedApiKey + " to " + ((ContainerRequest)requestContext).getRequestUri().toString());
                } else {
                    ManagedUser user = null;
                    if (principal instanceof ManagedUser) {
                        user = qm.getManagedUser(((ManagedUser)principal).getUsername());
                    } else if (principal instanceof LdapUser) {
                        user = qm.getLdapUser(((LdapUser)principal).getUsername());
                    } else if (principal instanceof OidcUser) {
                        user = qm.getOidcUser(((OidcUser)principal).getUsername());
                    }
                    if (user == null) {
                        LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "A request was made but the system in unable to find the user principal");
                        requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                        return;
                    }
                    for (String permission : permissions) {
                        if (!qm.hasPermission((UserPrincipal)user, permission, true)) continue;
                        return;
                    }
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Unauthorized access attempt made by " + user.getUsername() + " to " + ((ContainerRequest)requestContext).getRequestUri().toString());
                }
            }
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }
}

