/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.persistence;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.common.metrics.Metrics;
import alpine.model.InstalledUpgrades;
import alpine.model.SchemaVersion;
import alpine.persistence.IPersistenceManagerFactory;
import alpine.persistence.JdoProperties;
import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ConnectionManagerImpl;
import org.datanucleus.store.rdbms.ConnectionFactoryImpl;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

public class PersistenceManagerFactory
implements IPersistenceManagerFactory,
ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(PersistenceManagerFactory.class);
    private static final String DATANUCLEUS_METRICS_PREFIX = "datanucleus_";
    private static JDOPersistenceManagerFactory pmf;

    public void contextInitialized(ServletContextEvent event) {
        LOGGER.info("Initializing persistence framework");
        pmf = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory((Map)JdoProperties.get(), (String)"Alpine");
        if (Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.METRICS_ENABLED)) {
            LOGGER.info("Registering DataNucleus metrics");
            this.registerDataNucleusMetrics(pmf);
            if (Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.DATABASE_POOL_ENABLED)) {
                LOGGER.info("Registering HikariCP metrics");
                try {
                    this.registerHikariMetrics(pmf);
                }
                catch (Exception ex) {
                    LOGGER.warn("An unexpected error occurred while registering HikariCP metrics", (Throwable)ex);
                }
            }
        }
        PersistenceNucleusContext ctx = pmf.getNucleusContext();
        HashSet<String> classNames = new HashSet<String>();
        classNames.add(InstalledUpgrades.class.getCanonicalName());
        classNames.add(SchemaVersion.class.getCanonicalName());
        ((SchemaAwareStoreManager)ctx.getStoreManager()).createSchemaForClasses(classNames, new Properties());
    }

    public void contextDestroyed(ServletContextEvent event) {
        LOGGER.info("Shutting down persistence framework");
        PersistenceManagerFactory.tearDown();
    }

    public static PersistenceManager createPersistenceManager() {
        if (pmf == null && Config.isUnitTestsEnabled()) {
            pmf = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory((Map)JdoProperties.unit(), (String)"Alpine");
        }
        if (pmf == null) {
            throw new IllegalStateException("Context is not initialized yet.");
        }
        return pmf.getPersistenceManager();
    }

    public PersistenceManager getPersistenceManager() {
        return PersistenceManagerFactory.createPersistenceManager();
    }

    public static void setJdoPersistenceManagerFactory(JDOPersistenceManagerFactory pmf) {
        if (PersistenceManagerFactory.pmf != null) {
            throw new IllegalStateException("The PersistenceManagerFactory can only be set when it hasn't been initialized yet.");
        }
        PersistenceManagerFactory.pmf = pmf;
    }

    public static void tearDown() {
        if (pmf != null) {
            pmf.close();
            pmf = null;
        }
    }

    private void registerDataNucleusMetrics(JDOPersistenceManagerFactory pmf) {
        FunctionCounter.builder((String)"datanucleus_datastore_reads_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfDatastoreReads()).description("Total number of read operations from the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_datastore_writes_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfDatastoreWrites()).description("Total number of write operations to the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_fetches_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectFetches()).description("Total number of objects fetched from the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_inserts_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectInserts()).description("Total number of objects inserted into the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_updates_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectUpdates()).description("Total number of objects updated in the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_deletes_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectDeletes()).description("Total number of objects deleted from the datastore").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_query_execution_time_ms_avg", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryExecutionTimeAverage()).description("Average query execution time in milliseconds").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_queries_active", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryActiveTotalCount()).description("Number of currently active queries").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_queries_executed_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryExecutionTotalCount()).description("Total number of executed queries").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_queries_failed_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryErrorTotalCount()).description("Total number of queries that completed with an error").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_transaction_execution_time_ms_avg", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionExecutionTimeAverage()).description("Average transaction execution time in milliseconds").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_active", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionActiveTotalCount()).description("Number of currently active transactions").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionTotalCount()).description("Total number of transactions").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_committed_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionCommittedTotalCount()).description("Total number of committed transactions").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_rolledback_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionRolledBackTotalCount()).description("Total number of rolled-back transactions").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_connections_active", (Object)pmf, p -> p.getNucleusContext().getStatistics().getConnectionActiveCurrent()).description("Number of currently active managed datastore connections").register((MeterRegistry)Metrics.getRegistry());
    }

    private void registerHikariMetrics(JDOPersistenceManagerFactory pmf) throws IllegalAccessException {
        RDBMSStoreManager storeManager;
        StoreManager storeManager2 = pmf.getNucleusContext().getStoreManager();
        if (storeManager2 instanceof RDBMSStoreManager && (storeManager2 = (storeManager = (RDBMSStoreManager)storeManager2).getConnectionManager()) instanceof ConnectionManagerImpl) {
            ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)storeManager2;
            this.registerConnectionPoolMetricsForConnectionFactory(FieldUtils.readField((Object)connectionManager, (String)"primaryConnectionFactory", (boolean)true));
            this.registerConnectionPoolMetricsForConnectionFactory(FieldUtils.readField((Object)connectionManager, (String)"secondaryConnectionFactory", (boolean)true));
        }
    }

    private void registerConnectionPoolMetricsForConnectionFactory(Object connectionFactory) throws IllegalAccessException {
        ConnectionFactoryImpl connectionFactoryImpl;
        Object dataSource;
        if (connectionFactory instanceof ConnectionFactoryImpl && (dataSource = FieldUtils.readField((Object)(connectionFactoryImpl = (ConnectionFactoryImpl)connectionFactory), (String)"dataSource", (boolean)true)) instanceof HikariDataSource) {
            HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
            hikariDataSource.setMetricRegistry((Object)Metrics.getRegistry());
        }
    }
}

