/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.servlets;

import alpine.common.logging.Logger;
import alpine.common.util.BooleanUtil;
import alpine.server.servlets.StaticResource;
import alpine.server.servlets.StaticResourceServlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class FileSystemResourceServlet
extends StaticResourceServlet {
    private static final Logger LOGGER = Logger.getLogger(FileSystemResourceServlet.class);
    private String directory;
    private boolean absolute;

    public void init(ServletConfig config) throws ServletException {
        String absolute;
        LOGGER.info("Initializing filesystem resource servlet");
        super.init(config);
        String directory = config.getInitParameter("directory");
        if (StringUtils.isNotBlank((CharSequence)directory)) {
            this.directory = directory;
        }
        if (StringUtils.isNotBlank((CharSequence)(absolute = config.getInitParameter("absolute")))) {
            this.absolute = BooleanUtil.valueOf((String)absolute);
        }
    }

    @Override
    protected StaticResource getStaticResource(HttpServletRequest request) throws IllegalArgumentException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty() || "/".equals(pathInfo)) {
            throw new IllegalArgumentException();
        }
        String name = "";
        try {
            name = URLDecoder.decode(pathInfo.substring(1), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage());
        }
        ServletContext context = request.getServletContext();
        final File file = this.absolute ? new File(this.directory, name) : new File(context.getRealPath("/"), name).getAbsoluteFile();
        return !file.exists() ? null : new StaticResource(){

            @Override
            public long getLastModified() {
                return file.lastModified();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }

            @Override
            public String getFileName() {
                return file.getName();
            }

            @Override
            public long getContentLength() {
                return file.length();
            }
        };
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }
}

