/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.servlets;

import alpine.server.servlets.StaticResource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class StaticResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final long ONE_SECOND_IN_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final String ETAG_HEADER = "W/\"%s-%s\"";
    private static final String CONTENT_DISPOSITION_HEADER = "inline;filename=\"%1$s\"; filename*=UTF-8''%1$s";
    private static final long DEFAULT_EXPIRE_TIME_IN_MILLIS = TimeUnit.DAYS.toMillis(30L);
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 102400;

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response, true);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response, false);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response, boolean head) throws IOException {
        StaticResource resource;
        response.reset();
        try {
            resource = this.getStaticResource(request);
        }
        catch (IllegalArgumentException e) {
            response.sendError(400);
            return;
        }
        if (resource == null) {
            response.sendError(404);
            return;
        }
        String fileName = URLEncoder.encode(resource.getFileName(), StandardCharsets.UTF_8.name());
        boolean notModified = this.setCacheHeaders(request, response, fileName, resource.getLastModified());
        if (notModified) {
            response.sendError(304);
            return;
        }
        this.setContentHeaders(response, fileName, resource.getContentLength());
        if (head) {
            return;
        }
        this.writeContent(response, resource);
    }

    protected abstract StaticResource getStaticResource(HttpServletRequest var1) throws IllegalArgumentException;

    private boolean setCacheHeaders(HttpServletRequest request, HttpServletResponse response, String fileName, long lastModified) {
        String eTag = String.format(ETAG_HEADER, fileName, lastModified);
        response.setHeader("ETag", eTag);
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("Expires", System.currentTimeMillis() + DEFAULT_EXPIRE_TIME_IN_MILLIS);
        return this.notModified(request, eTag, lastModified);
    }

    private boolean notModified(HttpServletRequest request, String eTag, long lastModified) {
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (ifNoneMatch != null) {
            Object[] matches = ifNoneMatch.split("\\s*,\\s*");
            Arrays.sort(matches);
            return Arrays.binarySearch(matches, eTag) > -1 || Arrays.binarySearch(matches, "*") > -1;
        }
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        return ifModifiedSince + ONE_SECOND_IN_MILLIS > lastModified;
    }

    private void setContentHeaders(HttpServletResponse response, String fileName, long contentLength) {
        response.setHeader("Content-Type", this.getServletContext().getMimeType(fileName));
        response.setHeader("Content-Disposition", String.format(CONTENT_DISPOSITION_HEADER, fileName));
        if (contentLength != -1L) {
            response.setHeader("Content-Length", String.valueOf(contentLength));
        }
    }

    private void writeContent(HttpServletResponse response, StaticResource resource) throws IOException {
        try (ReadableByteChannel inputChannel = Channels.newChannel(resource.getInputStream());
             WritableByteChannel outputChannel = Channels.newChannel((OutputStream)response.getOutputStream());){
            ByteBuffer buffer = ByteBuffer.allocateDirect(102400);
            long size = 0L;
            while (inputChannel.read(buffer) != -1) {
                buffer.flip();
                size += (long)outputChannel.write(buffer);
                buffer.clear();
            }
            if (resource.getContentLength() == -1L && !response.isCommitted()) {
                response.setHeader("Content-Length", String.valueOf(size));
            }
        }
    }
}

