/*
 * Decompiled with CFR 0.152.
 */
package alpine.server;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.security.crypto.KeyManager;
import io.jsonwebtoken.lang.Collections;
import io.swagger.jaxrs.config.SwaggerContextService;
import io.swagger.models.Info;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.glassfish.jersey.servlet.ServletContainer;
import org.owasp.security.logging.util.IntervalLoggerController;
import org.owasp.security.logging.util.SecurityLoggingFactory;
import org.owasp.security.logging.util.SecurityUtil;

public class AlpineServlet
extends ServletContainer {
    private static final long serialVersionUID = -133386507668410112L;
    private static final Logger LOGGER = Logger.getLogger(AlpineServlet.class);

    public void init(ServletConfig config) throws ServletException {
        LOGGER.info("Starting " + Config.getInstance().getApplicationName());
        super.init(config);
        Info info = new Info().title(Config.getInstance().getApplicationName() + " API").version(Config.getInstance().getApplicationVersion());
        Swagger swagger = new Swagger().info(info).securityDefinition("X-Api-Key", (SecuritySchemeDefinition)new ApiKeyAuthDefinition("X-Api-Key", In.HEADER));
        ServletContext servletContext = this.getServletContext();
        ServletRegistration servletRegistration = servletContext.getServletRegistration(config.getServletName());
        Collection mappings = servletRegistration.getMappings();
        if (!Collections.isEmpty((Collection)mappings)) {
            Object baseUrl = (String)mappings.iterator().next();
            if (((String)baseUrl).charAt(0) != '/') {
                baseUrl = "/" + (String)baseUrl;
            }
            baseUrl = ((String)baseUrl).replace("/*", "").replaceAll("\\/$", "");
            swagger.basePath(config.getServletContext().getContextPath() + (String)baseUrl);
        }
        new SwaggerContextService().withServletConfig(config).updateSwagger(swagger).initScanner();
        KeyManager.getInstance();
        SecurityUtil.logJavaSystemProperties();
        int interval = Config.getInstance().getPropertyAsInt((Config.Key)Config.AlpineKey.WATCHDOG_LOGGING_INTERVAL);
        if (interval > 0) {
            IntervalLoggerController wd = SecurityLoggingFactory.getControllerInstance();
            wd.start(interval * 1000);
        }
        LOGGER.info(Config.getInstance().getApplicationName() + " is ready");
    }

    public void destroy() {
        LOGGER.info("Stopping " + Config.getInstance().getApplicationName());
        super.destroy();
    }
}

