/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.common.validation.LdapStringSanitizer;
import alpine.model.LdapUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang3.StringUtils;

public class LdapConnectionWrapper {
    private static final Logger LOGGER = Logger.getLogger(LdapConnectionWrapper.class);
    private static final String BIND_USERNAME = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_BIND_USERNAME);
    private static final String BIND_PASSWORD = Config.getInstance().getPropertyOrFile(Config.AlpineKey.LDAP_BIND_PASSWORD);
    private static final String LDAP_SECURITY_AUTH = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_SECURITY_AUTH);
    private static final String LDAP_AUTH_USERNAME_FMT = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_AUTH_USERNAME_FMT);
    private static final String USER_GROUPS_FILTER = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_USER_GROUPS_FILTER);
    private static final String GROUPS_FILTER = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_GROUPS_FILTER);
    private static final String GROUPS_SEARCH_FILTER = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_GROUPS_SEARCH_FILTER);
    private static final String USERS_SEARCH_FILTER = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_USERS_SEARCH_FILTER);
    public static final boolean LDAP_ENABLED = Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.LDAP_ENABLED);
    public static final String LDAP_URL = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_SERVER_URL);
    public static final String BASE_DN = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_BASEDN);
    public static final String ATTRIBUTE_MAIL = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_ATTRIBUTE_MAIL);
    public static final String ATTRIBUTE_NAME = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.LDAP_ATTRIBUTE_NAME);
    public static final boolean USER_PROVISIONING = Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.LDAP_USER_PROVISIONING);
    public static final boolean TEAM_SYNCHRONIZATION = Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.LDAP_TEAM_SYNCHRONIZATION);
    public static final boolean LDAP_CONFIGURED = LDAP_ENABLED && StringUtils.isNotBlank((CharSequence)LDAP_URL);
    private static final boolean IS_LDAP_SSLTLS = StringUtils.isNotBlank((CharSequence)LDAP_URL) && LDAP_URL.startsWith("ldaps:");

    public LdapContext createLdapContext(String userDn, String password) throws NamingException {
        LOGGER.debug("Creating LDAP context for: " + userDn);
        if (StringUtils.isEmpty((CharSequence)userDn) || StringUtils.isEmpty((CharSequence)password)) {
            throw new NamingException("Username or password cannot be empty or null");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (StringUtils.isNotBlank((CharSequence)LDAP_SECURITY_AUTH)) {
            env.put("java.naming.security.authentication", LDAP_SECURITY_AUTH);
        }
        env.put("java.naming.security.principal", userDn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", LDAP_URL);
        if (IS_LDAP_SSLTLS) {
            env.put("java.naming.ldap.factory.socket", "alpine.security.crypto.RelaxedSSLSocketFactory");
        }
        try {
            return new InitialLdapContext(env, null);
        }
        catch (CommunicationException e) {
            LOGGER.error("Failed to connect to directory server", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            throw new NamingException("Failed to authenticate user");
        }
    }

    public DirContext createDirContext() throws NamingException {
        LOGGER.debug("Creating directory service context (DirContext)");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", BIND_USERNAME);
        env.put("java.naming.security.credentials", BIND_PASSWORD);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", LDAP_URL);
        if (IS_LDAP_SSLTLS) {
            env.put("java.naming.ldap.factory.socket", "alpine.security.crypto.RelaxedSSLSocketFactory");
        }
        return new InitialDirContext(env);
    }

    public List<String> getGroups(DirContext dirContext, LdapUser ldapUser) throws NamingException {
        LOGGER.debug("Retrieving groups for: " + ldapUser.getDN());
        ArrayList<String> groupDns = new ArrayList<String>();
        String searchFilter = this.variableSubstitution(USER_GROUPS_FILTER, ldapUser);
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = dirContext.search(BASE_DN, searchFilter, sc);
        while (this.hasMoreEnum(ne)) {
            SearchResult result = ne.next();
            groupDns.add(result.getNameInNamespace());
            LOGGER.debug("Found group: " + result.getNameInNamespace() + " for user: " + ldapUser.getDN());
        }
        this.closeQuietly(ne);
        return groupDns;
    }

    public List<String> getGroups(DirContext dirContext) throws NamingException {
        LOGGER.debug("Retrieving all groups");
        ArrayList<String> groupDns = new ArrayList<String>();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        NamingEnumeration<SearchResult> ne = dirContext.search(BASE_DN, GROUPS_FILTER, sc);
        while (this.hasMoreEnum(ne)) {
            SearchResult result = ne.next();
            groupDns.add(result.getNameInNamespace());
            LOGGER.debug("Found group: " + result.getNameInNamespace());
        }
        this.closeQuietly(ne);
        return groupDns;
    }

    public List<String> searchForGroupName(DirContext dirContext, String groupName) throws NamingException {
        return this.search(dirContext, GROUPS_SEARCH_FILTER, groupName);
    }

    public List<String> searchForUserName(DirContext dirContext, String userName) throws NamingException {
        return this.search(dirContext, USERS_SEARCH_FILTER, userName);
    }

    public List<String> search(DirContext dirContext, String filter, String searchTerm) throws NamingException {
        LOGGER.debug("Searching / filter: " + filter + " searchTerm: " + searchTerm);
        ArrayList<String> entityDns = new ArrayList<String>();
        String[] attributeFilter = new String[]{};
        SearchControls sc = new SearchControls();
        sc.setReturningAttributes(attributeFilter);
        sc.setSearchScope(2);
        String searchFor = this.searchTermSubstitution(filter, searchTerm);
        LOGGER.debug("Searching for: " + searchFor);
        NamingEnumeration<SearchResult> ne = dirContext.search(BASE_DN, searchFor, sc);
        while (this.hasMoreEnum(ne)) {
            SearchResult result = ne.next();
            entityDns.add(result.getNameInNamespace());
            LOGGER.debug("Found: " + result.getNameInNamespace());
        }
        this.closeQuietly(ne);
        return entityDns;
    }

    public List<SearchResult> searchForUsername(DirContext ctx, String username) throws NamingException {
        LOGGER.debug("Performing a directory search for: " + username);
        String[] attributeFilter = new String[]{};
        SearchControls sc = new SearchControls();
        sc.setReturningAttributes(attributeFilter);
        sc.setSearchScope(2);
        String searchFor = ATTRIBUTE_NAME + "=" + LdapStringSanitizer.sanitize((String)LdapConnectionWrapper.formatPrincipal(username));
        LOGGER.debug("Searching for: " + searchFor);
        return Collections.list(ctx.search(BASE_DN, searchFor, sc));
    }

    public SearchResult searchForSingleUsername(DirContext ctx, String username) throws NamingException {
        List<SearchResult> results = this.searchForUsername(ctx, username);
        if (results == null || results.size() == 0) {
            LOGGER.debug("Search for (" + username + ") did not produce any results");
            return null;
        }
        if (results.size() == 1) {
            LOGGER.debug("Search for (" + username + ") produced a result");
            return results.get(0);
        }
        throw new NamingException("Multiple entries in the directory contain the same username. This scenario is not supported");
    }

    public String getAttribute(DirContext ctx, String dn, String attributeName) throws NamingException {
        Attributes attributes = ctx.getAttributes(dn);
        return this.getAttribute(attributes, attributeName);
    }

    public String getAttribute(SearchResult result, String attributeName) throws NamingException {
        return this.getAttribute(result.getAttributes(), attributeName);
    }

    public String getAttribute(Attributes attributes, String attributeName) throws NamingException {
        Object o;
        if (attributes == null || attributes.size() == 0) {
            return null;
        }
        Attribute attribute = attributes.get(attributeName);
        if (attribute != null && (o = attribute.get()) instanceof String) {
            return (String)attribute.get();
        }
        return null;
    }

    private static String formatPrincipal(String username) {
        if (StringUtils.isNotBlank((CharSequence)LDAP_AUTH_USERNAME_FMT)) {
            return String.format(LDAP_AUTH_USERNAME_FMT, username);
        }
        return username;
    }

    private String variableSubstitution(String s, LdapUser user) {
        if (s == null) {
            return null;
        }
        return s.replace("{USER_DN}", LdapStringSanitizer.sanitize((String)user.getDN())).replace("{USERNAME}", LdapStringSanitizer.sanitize((String)user.getUsername()));
    }

    private String searchTermSubstitution(String ldapFilter, String searchTerm) {
        if (ldapFilter == null) {
            return null;
        }
        if (searchTerm == null) {
            searchTerm = "";
        }
        return ldapFilter.replace("{SEARCH_TERM}", LdapStringSanitizer.sanitize((String)searchTerm));
    }

    private boolean hasMoreEnum(NamingEnumeration<SearchResult> ne) throws NamingException {
        if (ne == null) {
            return false;
        }
        boolean hasMore = true;
        try {
            if (!ne.hasMore()) {
                hasMore = false;
            }
        }
        catch (PartialResultException e) {
            hasMore = false;
            LOGGER.warn("Partial results returned. If this is an Active Directory server, try using port 3268 or 3269 in " + Config.AlpineKey.LDAP_SERVER_URL.name());
        }
        return hasMore;
    }

    public void closeQuietly(NamingEnumeration object) {
        try {
            if (object != null) {
                object.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void closeQuietly(DirContext object) {
        try {
            if (object != null) {
                object.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

