/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.server.auth.OidcConfiguration;
import alpine.server.cache.CacheManager;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import javax.annotation.Nullable;

public class OidcConfigurationResolver {
    private static final OidcConfigurationResolver INSTANCE = new OidcConfigurationResolver(Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.OIDC_ENABLED), Config.getInstance().getProperty((Config.Key)Config.AlpineKey.OIDC_ISSUER));
    private static final Logger LOGGER = Logger.getLogger(OidcConfigurationResolver.class);
    static final String CONFIGURATION_CACHE_KEY = "OIDC_CONFIGURATION";
    private final boolean oidcEnabled;
    private final String issuer;

    OidcConfigurationResolver(boolean oidcEnabled, String issuer) {
        this.oidcEnabled = oidcEnabled;
        this.issuer = issuer;
    }

    public static OidcConfigurationResolver getInstance() {
        return INSTANCE;
    }

    @Nullable
    public OidcConfiguration resolve() {
        OIDCProviderMetadata providerMetadata;
        if (!this.oidcEnabled) {
            LOGGER.debug("Will not resolve OIDC configuration: OIDC is disabled");
            return null;
        }
        if (this.issuer == null) {
            LOGGER.error("Cannot resolve OIDC configuration: No issuer provided");
            return null;
        }
        OidcConfiguration configuration = (OidcConfiguration)CacheManager.getInstance().get(OidcConfiguration.class, CONFIGURATION_CACHE_KEY);
        if (configuration != null) {
            LOGGER.debug("OIDC configuration loaded from cache");
            return configuration;
        }
        LOGGER.debug("Fetching OIDC configuration from issuer " + this.issuer);
        try {
            providerMetadata = OIDCProviderMetadata.resolve((Issuer)new Issuer(this.issuer));
        }
        catch (GeneralException | IOException e) {
            LOGGER.error("Failed to fetch OIDC configuration from issuer " + this.issuer, e);
            return null;
        }
        configuration = new OidcConfiguration();
        configuration.setIssuer(providerMetadata.getIssuer().getValue());
        configuration.setJwksUri(providerMetadata.getJWKSetURI());
        configuration.setUserInfoEndpointUri(providerMetadata.getUserInfoEndpointURI());
        LOGGER.debug("Storing OIDC configuration in cache: " + configuration);
        CacheManager.getInstance().put(CONFIGURATION_CACHE_KEY, configuration);
        return configuration;
    }
}

