/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class ClickjackingFilter
implements Filter {
    private String mode = "DENY";

    public void init(FilterConfig filterConfig) {
        String mode = filterConfig.getInitParameter("mode");
        String uri = filterConfig.getInitParameter("uri");
        if (StringUtils.isNotBlank((CharSequence)mode)) {
            if ("ALLOW-FROM".equals(mode)) {
                this.mode = mode + " " + uri;
            } else if ("DENY".equals(mode) || "SAMEORIGIN".equals(mode)) {
                this.mode = mode;
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        chain.doFilter(req, (ServletResponse)response);
        response.addHeader("X-Frame-Options", this.mode);
    }

    public void destroy() {
    }
}

