/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.util;

import alpine.model.UserPrincipal;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public final class GravatarUtil {
    private GravatarUtil() {
    }

    public static String generateHash(String emailAddress) {
        if (StringUtils.isBlank((CharSequence)emailAddress)) {
            return null;
        }
        return DigestUtils.md5Hex((String)emailAddress.trim().toLowerCase()).toLowerCase();
    }

    public static String getGravatarUrl(UserPrincipal userPrincipal) {
        return GravatarUtil.getGravatarUrl(userPrincipal.getEmail());
    }

    public static String getGravatarUrl(UserPrincipal userPrincipal, int size) {
        return GravatarUtil.getGravatarUrl(userPrincipal.getEmail(), size);
    }

    public static String getGravatarUrl(String emailAddress) {
        String hash = GravatarUtil.generateHash(emailAddress);
        if (hash == null) {
            return "https://www.gravatar.com/avatar/00000000000000000000000000000000.jpg?d=mm";
        }
        return "https://www.gravatar.com/avatar/" + hash + ".jpg?d=mm";
    }

    public static String getGravatarUrl(String emailAddress, int size) {
        return GravatarUtil.getGravatarUrl(emailAddress) + "&s=" + size;
    }
}

