/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.common.logging.Logger;
import alpine.common.util.ProxyConfig;
import alpine.common.util.ProxyUtil;
import alpine.server.auth.AlpineAuthenticationException;
import alpine.server.auth.OidcConfiguration;
import alpine.server.auth.OidcProfile;
import alpine.server.auth.OidcProfileCreator;
import alpine.server.cache.CacheManager;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.text.ParseException;

class OidcIdTokenAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(OidcIdTokenAuthenticator.class);
    static final String JWK_SET_CACHE_KEY = "OIDC_JWK_SET";
    private final OidcConfiguration configuration;
    private final String clientId;

    OidcIdTokenAuthenticator(OidcConfiguration configuration, String clientId) {
        this.configuration = configuration;
        this.clientId = clientId;
    }

    OidcProfile authenticate(String idToken, OidcProfileCreator profileCreator) throws AlpineAuthenticationException {
        IDTokenClaimsSet claimsSet;
        JWKSet jwkSet;
        SignedJWT parsedIdToken;
        try {
            parsedIdToken = SignedJWT.parse((String)idToken);
        }
        catch (ParseException e) {
            LOGGER.error("Parsing ID token failed", (Throwable)e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
        }
        try {
            jwkSet = this.resolveJwkSet();
        }
        catch (IOException | ParseException e) {
            LOGGER.error("Resolving JWK set failed", (Throwable)e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        IDTokenValidator idTokenValidator = new IDTokenValidator(new Issuer(this.configuration.getIssuer()), new ClientID(this.clientId), parsedIdToken.getHeader().getAlgorithm(), jwkSet);
        try {
            claimsSet = idTokenValidator.validate((JWT)parsedIdToken, null);
            LOGGER.debug("ID token claims: " + claimsSet.toJSONString());
        }
        catch (JOSEException | BadJOSEException e) {
            LOGGER.error("ID token validation failed", e);
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
        }
        return profileCreator.create((ClaimsSet)claimsSet);
    }

    JWKSet resolveJwkSet() throws IOException, ParseException {
        JWKSet jwkSet = (JWKSet)CacheManager.getInstance().get(JWKSet.class, JWK_SET_CACHE_KEY);
        if (jwkSet != null) {
            LOGGER.debug("JWK set loaded from cache");
            return jwkSet;
        }
        LOGGER.debug("Fetching JWK set from " + this.configuration.getJwksUri());
        URL jwksUrl = this.configuration.getJwksUri().toURL();
        ProxyConfig proxyCfg = ProxyUtil.getProxyConfig();
        if (proxyCfg != null && proxyCfg.shouldProxy(jwksUrl)) {
            LOGGER.debug("Using proxy to fetch JWK set");
            jwkSet = JWKSet.load((URL)this.configuration.getJwksUri().toURL(), (int)0, (int)0, (int)0, (Proxy)proxyCfg.getProxy());
        } else {
            jwkSet = JWKSet.load((URL)jwksUrl);
        }
        LOGGER.debug("Storing JWK set in cache");
        CacheManager.getInstance().put(JWK_SET_CACHE_KEY, jwkSet);
        return jwkSet;
    }
}

