/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import alpine.Config;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.apache.commons.lang3.StringUtils;

@Priority(value=3000)
public class HeaderFilter
implements ContainerResponseFilter {
    private static final String APP_NAME = Config.getInstance().getApplicationName();
    private static final String APP_VERSION = Config.getInstance().getApplicationVersion();
    private static final boolean CORS_ENABLED = Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.CORS_ENABLED);
    private static final String CORS_ALLOW_ORIGIN = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.CORS_ALLOW_ORIGIN);
    private static final String CORS_ALLOW_METHODS = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.CORS_ALLOW_METHODS);
    private static final String CORS_ALLOW_HEADERS = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.CORS_ALLOW_HEADERS);
    private static final String CORS_EXPOSE_HEADERS = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.CORS_EXPOSE_HEADERS);
    private static final boolean CORS_ALLOW_CREDENTIALS = Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.CORS_ALLOW_CREDENTIALS);
    private static final int CORS_MAX_AGE = Config.getInstance().getPropertyAsInt((Config.Key)Config.AlpineKey.CORS_MAX_AGE);

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        responseContext.getHeaders().add((Object)"X-Powered-By", (Object)(APP_NAME + " v" + APP_VERSION));
        responseContext.getHeaders().add((Object)"Cache-Control", (Object)"private, max-age=0, must-revalidate, no-cache");
        if (CORS_ENABLED) {
            if (StringUtils.isNotBlank((CharSequence)CORS_ALLOW_ORIGIN)) {
                responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)CORS_ALLOW_ORIGIN);
            }
            if (StringUtils.isNotBlank((CharSequence)CORS_ALLOW_METHODS)) {
                responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)CORS_ALLOW_METHODS);
            }
            if (StringUtils.isNotBlank((CharSequence)CORS_ALLOW_HEADERS)) {
                responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)CORS_ALLOW_HEADERS);
            }
            if (StringUtils.isNotBlank((CharSequence)CORS_EXPOSE_HEADERS)) {
                responseContext.getHeaders().add((Object)"Access-Control-Expose-Headers", (Object)CORS_EXPOSE_HEADERS);
            }
            if (CORS_ALLOW_CREDENTIALS) {
                responseContext.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
            }
            if (CORS_MAX_AGE != 0) {
                responseContext.getHeaders().add((Object)"Access-Control-Max-Age", (Object)CORS_MAX_AGE);
            }
        }
    }
}

