/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import alpine.server.util.HttpUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class RequestRateThrottleFilter
implements Filter {
    private int maximumRequestsPerPeriod = 5;
    private int timePeriodSeconds = 10;
    private static final String MAXIMUM_REQUESTS_PER_PERIOD = "maximumRequestsPerPeriod";
    private static final String TIME_PERIOD_SECONDS = "timePeriodSeconds";

    public void init(FilterConfig filterConfig) {
        this.maximumRequestsPerPeriod = Integer.parseInt(filterConfig.getInitParameter(MAXIMUM_REQUESTS_PER_PERIOD));
        this.timePeriodSeconds = Integer.parseInt(filterConfig.getInitParameter(TIME_PERIOD_SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(true);
        String string = session.getId().intern();
        synchronized (string) {
            Stack<Date> times = (Stack<Date>)HttpUtil.getSessionAttribute(session, "times");
            if (times == null) {
                times = new Stack<Date>();
                times.push(new Date(0L));
                session.setAttribute("times", times);
            }
            times.push(new Date());
            if (times.size() >= this.maximumRequestsPerPeriod) {
                times.removeElementAt(0);
            }
            Date newest = (Date)times.get(times.size() - 1);
            Date oldest = (Date)times.get(0);
            long elapsed = newest.getTime() - oldest.getTime();
            if (elapsed < (long)(this.timePeriodSeconds * 1000)) {
                httpResponse.sendError(429);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

