/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.persistence;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.common.metrics.Metrics;
import alpine.model.InstalledUpgrades;
import alpine.model.SchemaVersion;
import alpine.persistence.IPersistenceManagerFactory;
import alpine.persistence.JdoProperties;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.PropertyNames;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

public class PersistenceManagerFactory
implements IPersistenceManagerFactory,
ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(PersistenceManagerFactory.class);
    private static final String DATANUCLEUS_METRICS_PREFIX = "datanucleus_";
    private static JDOPersistenceManagerFactory pmf;

    public void contextInitialized(ServletContextEvent event) {
        LOGGER.info("Initializing persistence framework");
        Properties dnProps = new Properties();
        dnProps.putAll((Map<?, ?>)Config.getInstance().getPassThroughProperties("datanucleus"));
        dnProps.put(PropertyNames.PROPERTY_SCHEMA_AUTOCREATE_DATABASE, "true");
        dnProps.put(PropertyNames.PROPERTY_SCHEMA_AUTOCREATE_TABLES, "true");
        dnProps.put(PropertyNames.PROPERTY_SCHEMA_AUTOCREATE_COLUMNS, "true");
        dnProps.put(PropertyNames.PROPERTY_SCHEMA_AUTOCREATE_CONSTRAINTS, "true");
        dnProps.put("datanucleus.schema.generatedatabase.mode", "create");
        dnProps.put("datanucleus.query.jdoql.allowall", "true");
        if (Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.METRICS_ENABLED)) {
            dnProps.put("datanucleus.enablestatistics", "true");
        }
        if (Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.DATABASE_POOL_ENABLED)) {
            LOGGER.info("Creating transactional connection pool");
            dnProps.put(PropertyNames.PROPERTY_CONNECTION_FACTORY, this.createTxPooledDataSource());
            LOGGER.info("Creating non-transactional connection pool");
            dnProps.put(PropertyNames.PROPERTY_CONNECTION_FACTORY2, this.createNonTxPooledDataSource());
        } else {
            dnProps.put(PropertyNames.PROPERTY_CONNECTION_URL, Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_URL));
            dnProps.put(PropertyNames.PROPERTY_CONNECTION_DRIVER_NAME, Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_DRIVER));
            dnProps.put(PropertyNames.PROPERTY_CONNECTION_USER_NAME, Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_USERNAME));
            dnProps.put(PropertyNames.PROPERTY_CONNECTION_PASSWORD, Config.getInstance().getPropertyOrFile(Config.AlpineKey.DATABASE_PASSWORD));
        }
        pmf = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory((Map)dnProps, (String)"Alpine");
        if (Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.METRICS_ENABLED)) {
            LOGGER.info("Registering DataNucleus metrics");
            this.registerDataNucleusMetrics(pmf);
        }
        PersistenceNucleusContext ctx = pmf.getNucleusContext();
        HashSet<String> classNames = new HashSet<String>();
        classNames.add(InstalledUpgrades.class.getCanonicalName());
        classNames.add(SchemaVersion.class.getCanonicalName());
        ((SchemaAwareStoreManager)ctx.getStoreManager()).createSchemaForClasses(classNames, new Properties());
    }

    public void contextDestroyed(ServletContextEvent event) {
        LOGGER.info("Shutting down persistence framework");
        PersistenceManagerFactory.tearDown();
    }

    public static PersistenceManager createPersistenceManager() {
        if (pmf == null && Config.isUnitTestsEnabled()) {
            pmf = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory((Map)JdoProperties.unit(), (String)"Alpine");
        }
        if (pmf == null) {
            throw new IllegalStateException("Context is not initialized yet.");
        }
        return pmf.getPersistenceManager();
    }

    public PersistenceManager getPersistenceManager() {
        return PersistenceManagerFactory.createPersistenceManager();
    }

    public static void setJdoPersistenceManagerFactory(JDOPersistenceManagerFactory pmf) {
        if (PersistenceManagerFactory.pmf != null) {
            throw new IllegalStateException("The PersistenceManagerFactory can only be set when it hasn't been initialized yet.");
        }
        PersistenceManagerFactory.pmf = pmf;
    }

    public static void tearDown() {
        if (pmf != null) {
            pmf.close();
            pmf = null;
        }
    }

    private void registerDataNucleusMetrics(JDOPersistenceManagerFactory pmf) {
        FunctionCounter.builder((String)"datanucleus_datastore_reads_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfDatastoreReads()).description("Total number of read operations from the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_datastore_writes_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfDatastoreWrites()).description("Total number of write operations to the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_fetches_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectFetches()).description("Total number of objects fetched from the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_inserts_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectInserts()).description("Total number of objects inserted into the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_updates_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectUpdates()).description("Total number of objects updated in the datastore").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_object_deletes_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getNumberOfObjectDeletes()).description("Total number of objects deleted from the datastore").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_query_execution_time_ms_avg", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryExecutionTimeAverage()).description("Average query execution time in milliseconds").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_queries_active", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryActiveTotalCount()).description("Number of currently active queries").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_queries_executed_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryExecutionTotalCount()).description("Total number of executed queries").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_queries_failed_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getQueryErrorTotalCount()).description("Total number of queries that completed with an error").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_transaction_execution_time_ms_avg", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionExecutionTimeAverage()).description("Average transaction execution time in milliseconds").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_active", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionActiveTotalCount()).description("Number of currently active transactions").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionTotalCount()).description("Total number of transactions").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_committed_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionCommittedTotalCount()).description("Total number of committed transactions").register((MeterRegistry)Metrics.getRegistry());
        FunctionCounter.builder((String)"datanucleus_transactions_rolledback_total", (Object)pmf, p -> p.getNucleusContext().getStatistics().getTransactionRolledBackTotalCount()).description("Total number of rolled-back transactions").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_connections_active", (Object)pmf, p -> p.getNucleusContext().getStatistics().getConnectionActiveCurrent()).description("Number of currently active managed datastore connections").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_cache_second_level_entries", (Object)pmf, p -> p.getNucleusContext().getLevel2Cache().getSize()).description("Number of entries in the second level cache").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_cache_query_generic_compilation_entries", (Object)pmf, p -> p.getQueryGenericCompilationCache().size()).description("Number of entries in the generic query compilation cache").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_cache_query_datastore_compilation_entries", (Object)pmf, p -> p.getQueryDatastoreCompilationCache().size()).description("Number of entries in the datastore query compilation cache").register((MeterRegistry)Metrics.getRegistry());
        Gauge.builder((String)"datanucleus_cache_query_result_entries", (Object)pmf, p -> p.getQueryCache().getQueryCache().size()).description("Number of entries in the query result cache").register((MeterRegistry)Metrics.getRegistry());
    }

    private DataSource createTxPooledDataSource() {
        HikariConfig hikariConfig = this.createBaseHikariConfig("transactional");
        hikariConfig.setMaximumPoolSize(this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_TX_MAX_SIZE, (Config.Key)Config.AlpineKey.DATABASE_POOL_MAX_SIZE, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setMinimumIdle(this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_TX_MIN_IDLE, (Config.Key)Config.AlpineKey.DATABASE_POOL_MIN_IDLE, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setMaxLifetime((long)this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_TX_MAX_LIFETIME, (Config.Key)Config.AlpineKey.DATABASE_POOL_MAX_LIFETIME, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setIdleTimeout((long)this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_TX_IDLE_TIMEOUT, (Config.Key)Config.AlpineKey.DATABASE_POOL_IDLE_TIMEOUT, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setKeepaliveTime((long)this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_TX_KEEPALIVE_INTERVAL, (Config.Key)Config.AlpineKey.DATABASE_POOL_KEEPALIVE_INTERVAL, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        return new HikariDataSource(hikariConfig);
    }

    private DataSource createNonTxPooledDataSource() {
        HikariConfig hikariConfig = this.createBaseHikariConfig("non-transactional");
        hikariConfig.setMaximumPoolSize(this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_NONTX_MAX_SIZE, (Config.Key)Config.AlpineKey.DATABASE_POOL_MAX_SIZE, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setMinimumIdle(this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_NONTX_MIN_IDLE, (Config.Key)Config.AlpineKey.DATABASE_POOL_MIN_IDLE, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setMaxLifetime((long)this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_NONTX_MAX_LIFETIME, (Config.Key)Config.AlpineKey.DATABASE_POOL_MAX_LIFETIME, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setIdleTimeout((long)this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_NONTX_IDLE_TIMEOUT, (Config.Key)Config.AlpineKey.DATABASE_POOL_IDLE_TIMEOUT, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        hikariConfig.setKeepaliveTime((long)this.getConfigPropertyWithFallback((Config.Key)Config.AlpineKey.DATABASE_POOL_NONTX_KEEPALIVE_INTERVAL, (Config.Key)Config.AlpineKey.DATABASE_POOL_KEEPALIVE_INTERVAL, arg_0 -> ((Config)Config.getInstance()).getPropertyAsInt(arg_0)).intValue());
        return new HikariDataSource(hikariConfig);
    }

    private HikariConfig createBaseHikariConfig(String poolName) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName(poolName);
        hikariConfig.setJdbcUrl(Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_URL));
        hikariConfig.setDriverClassName(Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_DRIVER));
        hikariConfig.setUsername(Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_USERNAME));
        hikariConfig.setPassword(Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_PASSWORD));
        if (Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.METRICS_ENABLED)) {
            hikariConfig.setMetricRegistry((Object)Metrics.getRegistry());
        }
        return hikariConfig;
    }

    private <T> T getConfigPropertyWithFallback(Config.Key key, Config.Key fallbackKey, Function<Config.Key, T> method) {
        if (Config.getInstance().getProperty(key) != null) {
            return method.apply(key);
        }
        return method.apply(fallbackKey);
    }
}

