/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import alpine.common.logging.Logger;
import alpine.server.auth.ApiKeyAuthenticationService;
import alpine.server.auth.JwtAuthenticationService;
import java.security.Principal;
import javax.annotation.Priority;
import javax.naming.AuthenticationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;
import org.owasp.security.logging.SecurityMarkers;

@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationFilter.class);

    public void filter(ContainerRequestContext requestContext) {
        if (requestContext instanceof ContainerRequest) {
            JwtAuthenticationService jwtAuthService;
            ContainerRequest request = (ContainerRequest)requestContext;
            if ("OPTIONS".equals(request.getMethod())) {
                return;
            }
            if (request.getRequestUri().getPath().contains("/api/swagger")) {
                return;
            }
            Principal principal = null;
            ApiKeyAuthenticationService apiKeyAuthService = new ApiKeyAuthenticationService(request);
            if (apiKeyAuthService.isSpecified()) {
                try {
                    principal = apiKeyAuthService.authenticate();
                }
                catch (AuthenticationException e) {
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Invalid API key asserted");
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                    return;
                }
            }
            if ((jwtAuthService = new JwtAuthenticationService(request)).isSpecified()) {
                try {
                    principal = jwtAuthService.authenticate();
                }
                catch (AuthenticationException e) {
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Invalid JWT asserted");
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                    return;
                }
            }
            if (principal == null) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            } else {
                requestContext.setProperty("Principal", (Object)principal);
            }
        }
    }
}

