/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class FqdnForwardFilter
implements Filter {
    private String host = null;

    public void init(FilterConfig filterConfig) {
        String host = filterConfig.getInitParameter("host");
        if (StringUtils.isNotBlank((CharSequence)host)) {
            this.host = host;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getServerName().equals(this.host)) {
            chain.doFilter(request, response);
            return;
        }
        res.setStatus(301);
        StringBuilder sb = new StringBuilder();
        sb.append("http");
        if (req.isSecure()) {
            sb.append("s");
        }
        sb.append("://").append(this.host);
        if (StringUtils.isNotBlank((CharSequence)req.getPathInfo())) {
            sb.append(req.getPathInfo());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getQueryString())) {
            sb.append("?").append(req.getQueryString());
        }
        res.setHeader("Location", sb.toString());
    }

    public void destroy() {
    }
}

