/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class GZipInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    private final HttpHeaders httpHeaders;

    public GZipInterceptor(@Context @NotNull HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        List header = (List)context.getHeaders().get((Object)"Content-Encoding");
        if (header != null && header.contains("gzip")) {
            InputStream contentInputSteam = context.getInputStream();
            GZIPInputStream gzipInputStream = new GZIPInputStream(contentInputSteam);
            context.setInputStream((InputStream)gzipInputStream);
        }
        return context.proceed();
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        List requestHeader = this.httpHeaders.getRequestHeader("Accept-Encoding");
        if (requestHeader != null && requestHeader.contains("gzip")) {
            OutputStream contextOutputStream = context.getOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(contextOutputStream);
            context.setOutputStream((OutputStream)gzipOutputStream);
            context.getHeaders().add((Object)"Content-Encoding", (Object)"gzip");
        }
        context.proceed();
    }
}

