/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.model.OidcUser;
import alpine.persistence.AlpineQueryManager;
import alpine.server.auth.AlpineAuthenticationException;
import alpine.server.auth.AuthenticationService;
import alpine.server.auth.OidcConfiguration;
import alpine.server.auth.OidcConfigurationResolver;
import alpine.server.auth.OidcIdTokenAuthenticator;
import alpine.server.auth.OidcProfile;
import alpine.server.auth.OidcProfileCreator;
import alpine.server.auth.OidcUserInfoAuthenticator;
import alpine.server.util.OidcUtil;
import java.security.Principal;
import java.util.Objects;
import javax.annotation.Nonnull;

public class OidcAuthenticationService
implements AuthenticationService {
    private static final Logger LOGGER = Logger.getLogger(OidcAuthenticationService.class);
    private final Config config;
    private final OidcConfiguration oidcConfiguration;
    private final OidcIdTokenAuthenticator idTokenAuthenticator;
    private final OidcUserInfoAuthenticator userInfoAuthenticator;
    private final String idToken;
    private final String accessToken;

    @Deprecated
    public OidcAuthenticationService(String accessToken) {
        this(Config.getInstance(), OidcConfigurationResolver.getInstance().resolve(), null, accessToken);
    }

    public OidcAuthenticationService(String idToken, String accessToken) {
        this(Config.getInstance(), OidcConfigurationResolver.getInstance().resolve(), idToken, accessToken);
    }

    OidcAuthenticationService(Config config, OidcConfiguration oidcConfiguration, String idToken, String accessToken) {
        this(config, oidcConfiguration, new OidcIdTokenAuthenticator(oidcConfiguration, config.getProperty((Config.Key)Config.AlpineKey.OIDC_CLIENT_ID)), new OidcUserInfoAuthenticator(oidcConfiguration), idToken, accessToken);
    }

    OidcAuthenticationService(Config config, OidcConfiguration oidcConfiguration, OidcIdTokenAuthenticator idTokenAuthenticator, OidcUserInfoAuthenticator userInfoAuthenticator, String idToken, String accessToken) {
        this.config = config;
        this.oidcConfiguration = oidcConfiguration;
        this.idTokenAuthenticator = idTokenAuthenticator;
        this.userInfoAuthenticator = userInfoAuthenticator;
        this.idToken = idToken;
        this.accessToken = accessToken;
    }

    @Override
    public boolean isSpecified() {
        return OidcUtil.isOidcAvailable(this.config, this.oidcConfiguration) && (this.accessToken != null || this.idToken != null);
    }

    @Override
    @Nonnull
    public Principal authenticate() throws AlpineAuthenticationException {
        String usernameClaimName = this.config.getProperty((Config.Key)Config.AlpineKey.OIDC_USERNAME_CLAIM);
        if (usernameClaimName == null) {
            LOGGER.error("No username claim has been configured");
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        boolean teamSyncEnabled = this.config.getPropertyAsBoolean((Config.Key)Config.AlpineKey.OIDC_TEAM_SYNCHRONIZATION);
        String teamsClaimName = this.config.getProperty((Config.Key)Config.AlpineKey.OIDC_TEAMS_CLAIM);
        if (teamSyncEnabled && teamsClaimName == null) {
            LOGGER.error("Team synchronization is enabled, but no teams claim has been configured");
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
        }
        OidcProfileCreator profileCreator = claims -> {
            OidcProfile profile = new OidcProfile();
            profile.setSubject(claims.getStringClaim("sub"));
            profile.setUsername(claims.getStringClaim(usernameClaimName));
            profile.setGroups(claims.getStringListClaim(teamsClaimName));
            profile.setEmail(claims.getStringClaim("email"));
            return profile;
        };
        OidcProfile idTokenProfile = null;
        if (this.idToken != null) {
            idTokenProfile = this.idTokenAuthenticator.authenticate(this.idToken, profileCreator);
            LOGGER.debug("ID token profile: " + idTokenProfile);
            if (this.isProfileComplete(idTokenProfile, teamSyncEnabled)) {
                LOGGER.debug("ID token profile is complete, proceeding to authenticate");
                return this.authenticateInternal(idTokenProfile);
            }
        }
        OidcProfile userInfoProfile = null;
        if (this.accessToken != null) {
            userInfoProfile = this.userInfoAuthenticator.authenticate(this.accessToken, profileCreator);
            LOGGER.debug("UserInfo profile: " + userInfoProfile);
            if (this.isProfileComplete(userInfoProfile, teamSyncEnabled)) {
                LOGGER.debug("UserInfo profile is complete, proceeding to authenticate");
                return this.authenticateInternal(userInfoProfile);
            }
        }
        OidcProfile mergedProfile = null;
        if (idTokenProfile != null && userInfoProfile != null) {
            mergedProfile = this.mergeProfiles(idTokenProfile, userInfoProfile);
            LOGGER.debug("Merged profile: " + mergedProfile);
            if (this.isProfileComplete(mergedProfile, teamSyncEnabled)) {
                LOGGER.debug("Merged profile is complete, proceeding to authenticate");
                return this.authenticateInternal(mergedProfile);
            }
        }
        LOGGER.error("Unable to assemble complete profile (ID token: " + idTokenProfile + ", UserInfo: " + userInfoProfile + ", Merged: " + mergedProfile + ")");
        throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
    }

    private OidcUser authenticateInternal(OidcProfile profile) throws AlpineAuthenticationException {
        try (AlpineQueryManager qm = new AlpineQueryManager();){
            OidcUser user = qm.getOidcUser(profile.getUsername());
            if (user != null) {
                LOGGER.debug("Attempting to authenticate user: " + user.getUsername());
                if (user.getSubjectIdentifier() == null) {
                    LOGGER.debug("Assigning subject identifier " + profile.getSubject() + " to user " + user.getUsername());
                    user.setSubjectIdentifier(profile.getSubject());
                    user.setEmail(profile.getEmail());
                    OidcUser oidcUser = qm.updateOidcUser(user);
                    return oidcUser;
                }
                if (!user.getSubjectIdentifier().equals(profile.getSubject())) {
                    LOGGER.error("Refusing to authenticate user " + user.getUsername() + ": subject identifier has changed (" + user.getSubjectIdentifier() + " to " + profile.getSubject() + ")");
                    throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
                }
                if (!Objects.equals(user.getEmail(), profile.getEmail())) {
                    LOGGER.debug("Updating email of user " + user.getUsername() + ": " + user.getEmail() + " -> " + profile.getEmail());
                    user.setEmail(profile.getEmail());
                    user = qm.updateOidcUser(user);
                }
                if (this.config.getPropertyAsBoolean((Config.Key)Config.AlpineKey.OIDC_TEAM_SYNCHRONIZATION)) {
                    OidcUser oidcUser = qm.synchronizeTeamMembership(user, profile.getGroups());
                    return oidcUser;
                }
                OidcUser oidcUser = user;
                return oidcUser;
            }
            if (this.config.getPropertyAsBoolean((Config.Key)Config.AlpineKey.OIDC_USER_PROVISIONING)) {
                LOGGER.debug("The user (" + profile.getUsername() + ") authenticated successfully but the account has not been provisioned");
                OidcUser oidcUser = this.autoProvision(qm, profile);
                return oidcUser;
            }
            LOGGER.debug("The user (" + profile.getUsername() + ") is unmapped and user provisioning is not enabled");
            throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.UNMAPPED_ACCOUNT);
        }
    }

    private boolean isProfileComplete(OidcProfile profile, boolean teamSyncEnabled) {
        return profile.getSubject() != null && profile.getUsername() != null && (!teamSyncEnabled || profile.getGroups() != null);
    }

    private OidcProfile mergeProfiles(OidcProfile left, OidcProfile right) {
        OidcProfile profile = new OidcProfile();
        profile.setSubject(this.selectProfileClaim(left.getSubject(), right.getSubject()));
        profile.setUsername(this.selectProfileClaim(left.getUsername(), right.getUsername()));
        profile.setGroups(this.selectProfileClaim(left.getGroups(), right.getGroups()));
        profile.setEmail(this.selectProfileClaim(left.getEmail(), right.getEmail()));
        return profile;
    }

    private <T> T selectProfileClaim(T left, T right) {
        return left != null ? left : right;
    }

    private OidcUser autoProvision(AlpineQueryManager qm, OidcProfile profile) {
        OidcUser user = new OidcUser();
        user.setUsername(profile.getUsername());
        user.setSubjectIdentifier(profile.getSubject());
        user.setEmail(profile.getEmail());
        user = (OidcUser)qm.persist((Object)user);
        if (this.config.getPropertyAsBoolean((Config.Key)Config.AlpineKey.OIDC_TEAM_SYNCHRONIZATION)) {
            LOGGER.debug("Synchronizing teams for user " + user.getUsername());
            return qm.synchronizeTeamMembership(user, profile.getGroups());
        }
        return qm.addUserToTeams(user, this.config.getPropertyAsList((Config.Key)Config.AlpineKey.OIDC_TEAMS_DEFAULT));
    }
}

