/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.persistence;

import alpine.Config;
import alpine.common.logging.Logger;
import java.sql.SQLException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.Server;

public class PersistenceInitializer
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(PersistenceInitializer.class);
    private static Server dbServer;

    public void contextInitialized(ServletContextEvent event) {
        this.startDbServer();
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.stopDbServer();
    }

    private void startDbServer() {
        String mode = Config.getInstance().getProperty((Config.Key)Config.AlpineKey.DATABASE_MODE);
        int port = Config.getInstance().getPropertyAsInt((Config.Key)Config.AlpineKey.DATABASE_PORT);
        if (StringUtils.isEmpty((CharSequence)mode) || !"server".equals(mode) && !"embedded".equals(mode) && !"external".equals(mode)) {
            LOGGER.error("Database mode not specified. Expected values are 'server', 'embedded', or 'external'");
        }
        if (dbServer != null || "embedded".equals(mode) || "external".equals(mode)) {
            return;
        }
        String[] args = new String[]{"-tcp", "-tcpPort", String.valueOf(port), "-tcpAllowOthers", "-ifNotExists"};
        try {
            LOGGER.info("Attempting to start database service");
            dbServer = Server.createTcpServer((String[])args).start();
            LOGGER.info("Database service started");
        }
        catch (SQLException e) {
            LOGGER.error("Unable to start database service: " + e.getMessage());
            this.stopDbServer();
        }
    }

    private void stopDbServer() {
        LOGGER.info("Shutting down database service");
        if (dbServer != null) {
            dbServer.stop();
            dbServer.shutdown();
        }
    }
}

