/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.model.LdapUser;
import alpine.model.ManagedUser;
import alpine.model.OidcUser;
import alpine.persistence.AlpineQueryManager;
import alpine.server.auth.AuthenticationService;
import alpine.server.auth.IdentityProvider;
import alpine.server.auth.JsonWebToken;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import org.glassfish.jersey.server.ContainerRequest;

public class JwtAuthenticationService
implements AuthenticationService {
    private final String bearer;

    public JwtAuthenticationService(ContainerRequest request) {
        this.bearer = this.getAuthorizationToken((HttpHeaders)request);
    }

    @Override
    public boolean isSpecified() {
        return this.bearer != null;
    }

    @Override
    public Principal authenticate() throws AuthenticationException {
        JsonWebToken jwt;
        boolean isValid;
        if (this.bearer != null && (isValid = (jwt = new JsonWebToken()).validateToken(this.bearer))) {
            try (AlpineQueryManager qm = new AlpineQueryManager();){
                OidcUser oidcUser;
                if (jwt.getSubject() == null || jwt.getExpiration() == null) {
                    throw new AuthenticationException("Token does not contain a valid subject or expiration");
                }
                if (jwt.getIdentityProvider() == null || IdentityProvider.LOCAL == jwt.getIdentityProvider()) {
                    ManagedUser managedUser = qm.getManagedUser(jwt.getSubject());
                    if (managedUser != null) {
                        ManagedUser managedUser2 = managedUser.isSuspended() ? null : managedUser;
                        return managedUser2;
                    }
                } else if (IdentityProvider.LDAP == jwt.getIdentityProvider()) {
                    LdapUser ldapUser = qm.getLdapUser(jwt.getSubject());
                    if (ldapUser != null) {
                        LdapUser ldapUser2 = ldapUser;
                        return ldapUser2;
                    }
                } else if (IdentityProvider.OPENID_CONNECT == jwt.getIdentityProvider() && (oidcUser = qm.getOidcUser(jwt.getSubject())) != null) {
                    OidcUser oidcUser2 = oidcUser;
                    return oidcUser2;
                }
            }
        }
        return null;
    }

    private String getAuthorizationToken(HttpHeaders headers) {
        String bearer;
        List header;
        if (headers.getCookies() != null) {
            for (Map.Entry entry : headers.getCookies().entrySet()) {
                if (!"Authorization-Token".equals(((Cookie)entry.getValue()).getName())) continue;
                return ((Cookie)entry.getValue()).getValue();
            }
        }
        if ((header = headers.getRequestHeader("Authorization")) != null && (bearer = (String)header.get(0)) != null && bearer.startsWith("Bearer ")) {
            return bearer.substring("Bearer ".length());
        }
        return null;
    }
}

