/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.common.util.ProxyConfig;
import alpine.common.util.ProxyUtil;
import alpine.server.auth.OidcConfiguration;
import alpine.server.cache.CacheManager;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URL;
import net.minidev.json.JSONObject;

public class OidcConfigurationResolver {
    private static final OidcConfigurationResolver INSTANCE = new OidcConfigurationResolver(Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.OIDC_ENABLED), Config.getInstance().getProperty((Config.Key)Config.AlpineKey.OIDC_ISSUER));
    private static final Logger LOGGER = Logger.getLogger(OidcConfigurationResolver.class);
    static final String CONFIGURATION_CACHE_KEY = "OIDC_CONFIGURATION";
    private final boolean oidcEnabled;
    private final String issuer;

    OidcConfigurationResolver(boolean oidcEnabled, String issuer) {
        this.oidcEnabled = oidcEnabled;
        this.issuer = issuer;
    }

    public static OidcConfigurationResolver getInstance() {
        return INSTANCE;
    }

    @Nullable
    public OidcConfiguration resolve() {
        if (!this.oidcEnabled) {
            LOGGER.debug("Will not resolve OIDC configuration: OIDC is disabled");
            return null;
        }
        if (this.issuer == null) {
            LOGGER.error("Cannot resolve OIDC configuration: No issuer provided");
            return null;
        }
        OidcConfiguration configuration = (OidcConfiguration)CacheManager.getInstance().get(OidcConfiguration.class, CONFIGURATION_CACHE_KEY);
        if (configuration != null) {
            LOGGER.debug("OIDC configuration loaded from cache");
            return configuration;
        }
        LOGGER.debug("Fetching OIDC configuration from issuer " + this.issuer);
        try {
            HTTPResponse httpResponse;
            Issuer issuerObject = new Issuer(this.issuer);
            URL configURL = OIDCProviderMetadata.resolveURL((Issuer)issuerObject);
            HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, configURL);
            ProxyConfig proxyCfg = ProxyUtil.getProxyConfig();
            if (proxyCfg != null && proxyCfg.shouldProxy(configURL)) {
                httpRequest.setProxy(proxyCfg.getProxy());
            }
            if ((httpResponse = httpRequest.send()).getStatusCode() != 200) {
                throw new IOException("Couldn't download OpenID Provider metadata from " + String.valueOf(configURL) + ": Status code " + httpResponse.getStatusCode());
            }
            JSONObject jsonObject = httpResponse.getContentAsJSONObject();
            OIDCProviderMetadata op = OIDCProviderMetadata.parse((JSONObject)jsonObject);
            if (!issuerObject.equals((Object)op.getIssuer())) {
                throw new GeneralException("The returned issuer doesn't match the expected: " + String.valueOf(op.getIssuer()));
            }
            configuration = new OidcConfiguration();
            configuration.setIssuer(op.getIssuer().getValue());
            configuration.setJwksUri(op.getJWKSetURI());
            configuration.setUserInfoEndpointUri(op.getUserInfoEndpointURI());
            LOGGER.debug("Storing OIDC configuration in cache: " + String.valueOf(configuration));
            CacheManager.getInstance().put(CONFIGURATION_CACHE_KEY, configuration);
            return configuration;
        }
        catch (GeneralException | IOException e) {
            LOGGER.error("Failed to fetch OIDC configuration from issuer " + this.issuer, e);
            return null;
        }
    }
}

