/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.metrics;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.common.metrics.Metrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.DiskSpaceMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;

public class MetricsInitializer
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(MetricsInitializer.class);

    public void contextInitialized(ServletContextEvent event) {
        if (Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.METRICS_ENABLED)) {
            LOGGER.info("Registering system metrics");
            new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.getRegistry());
            new DiskSpaceMetrics(Config.getInstance().getDataDirectorty()).bindTo((MeterRegistry)Metrics.getRegistry());
            new JvmGcMetrics().bindTo((MeterRegistry)Metrics.getRegistry());
            new JvmInfoMetrics().bindTo((MeterRegistry)Metrics.getRegistry());
            new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.getRegistry());
            new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.getRegistry());
            new ProcessorMetrics().bindTo((MeterRegistry)Metrics.getRegistry());
            new UptimeMetrics().bindTo((MeterRegistry)Metrics.getRegistry());
        }
    }
}

