/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.servlets;

import alpine.common.logging.Logger;
import alpine.server.health.HealthCheckRegistry;
import alpine.server.health.HealthCheckType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

public class HealthServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(HealthServlet.class);
    private final HealthCheckRegistry checkRegistry;
    private ObjectMapper objectMapper;

    public HealthServlet() {
        this(HealthCheckRegistry.getInstance());
    }

    HealthServlet(HealthCheckRegistry checkRegistry) {
        this.checkRegistry = checkRegistry;
    }

    public void init() throws ServletException {
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HealthCheckType requestedCheckType = this.determineHealthCheckType(req);
        ArrayList<HealthCheckResponse> checkResponses = new ArrayList<HealthCheckResponse>();
        try {
            for (HealthCheck healthCheck : this.checkRegistry.getChecks().values()) {
                if (!this.matchesCheckType(healthCheck, requestedCheckType)) continue;
                LOGGER.debug("Calling health check: " + healthCheck.getClass().getName());
                checkResponses.add(healthCheck.call());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute health checks", (Throwable)e);
            resp.sendError(500);
            return;
        }
        HealthCheckResponse.Status overallStatus = checkResponses.stream().map(HealthCheckResponse::getStatus).filter(arg_0 -> HealthCheckResponse.Status.DOWN.equals(arg_0)).findFirst().orElse(HealthCheckResponse.Status.UP);
        ObjectNode responseJson = JsonNodeFactory.instance.objectNode().put("status", overallStatus.name()).putPOJO("checks", checkResponses);
        if (overallStatus == HealthCheckResponse.Status.UP) {
            resp.setStatus(200);
        } else {
            resp.setStatus(503);
        }
        try {
            resp.setHeader("Content-Type", "application/json");
            this.objectMapper.writeValue((Writer)resp.getWriter(), (Object)responseJson);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write health response", (Throwable)e);
            resp.sendError(500);
        }
    }

    private HealthCheckType determineHealthCheckType(HttpServletRequest req) {
        String requestPath = req.getPathInfo();
        if (requestPath == null) {
            return HealthCheckType.ALL;
        }
        return switch (requestPath) {
            case "/live" -> HealthCheckType.LIVENESS;
            case "/ready" -> HealthCheckType.READINESS;
            case "/started" -> HealthCheckType.STARTUP;
            default -> HealthCheckType.ALL;
        };
    }

    private boolean matchesCheckType(HealthCheck check, HealthCheckType requestedType) {
        Class checkClass = check.getClass();
        if (checkClass.isAnnotationPresent(Liveness.class) && (requestedType == HealthCheckType.ALL || requestedType == HealthCheckType.LIVENESS)) {
            return true;
        }
        if (checkClass.isAnnotationPresent(Readiness.class) && (requestedType == HealthCheckType.ALL || requestedType == HealthCheckType.READINESS)) {
            return true;
        }
        return checkClass.isAnnotationPresent(Startup.class) && (requestedType == HealthCheckType.ALL || requestedType == HealthCheckType.STARTUP);
    }
}

