/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.server.auth.AlpineAuthenticationException;
import alpine.server.auth.LdapAuthenticationService;
import alpine.server.auth.ManagedUserAuthenticationService;
import java.security.Principal;

public class Authenticator {
    private static final Logger LOGGER = Logger.getLogger(Authenticator.class);
    private static final boolean LDAP_ENABLED = Config.getInstance().getPropertyAsBoolean((Config.Key)Config.AlpineKey.LDAP_ENABLED);
    private final String username;
    private final String password;

    public Authenticator(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public Principal authenticate() throws AlpineAuthenticationException {
        block4: {
            LOGGER.debug("Attempting to authenticate user: " + this.username);
            ManagedUserAuthenticationService userService = new ManagedUserAuthenticationService(this.username, this.password);
            try {
                Principal principal = userService.authenticate();
                if (principal != null) {
                    return principal;
                }
            }
            catch (AlpineAuthenticationException e) {
                if (LDAP_ENABLED && e.getCauseType() == AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS) break block4;
                throw e;
            }
        }
        if (LDAP_ENABLED) {
            LdapAuthenticationService ldapService = new LdapAuthenticationService(this.username, this.password);
            return ldapService.authenticate();
        }
        throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
    }
}

