/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.logging.Logger;
import alpine.model.LdapUser;
import alpine.persistence.AlpineQueryManager;
import alpine.server.auth.AlpineAuthenticationException;
import alpine.server.auth.AuthenticationService;
import alpine.server.auth.LdapConnectionWrapper;
import java.security.Principal;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class LdapAuthenticationService
implements AuthenticationService {
    private static final Logger LOGGER = Logger.getLogger(LdapAuthenticationService.class);
    private final String username;
    private final String password;

    public LdapAuthenticationService(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public Principal authenticate() throws AlpineAuthenticationException {
        LOGGER.debug("Attempting to authenticate user: " + this.username);
        if (this.validateCredentials()) {
            try (AlpineQueryManager qm = new AlpineQueryManager();){
                LdapUser user = qm.getLdapUser(this.username);
                if (user != null) {
                    LOGGER.debug("Attempting to authenticate user: " + this.username);
                    LdapUser ldapUser = user;
                    return ldapUser;
                }
                if (LdapConnectionWrapper.USER_PROVISIONING) {
                    LOGGER.debug("The user (" + this.username + ") authenticated successfully but the account has not been provisioned");
                    LdapUser ldapUser = this.autoProvision(qm);
                    return ldapUser;
                }
                LOGGER.debug("The user (" + this.username + ") is unmapped and user provisioning is not enabled");
                throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.UNMAPPED_ACCOUNT);
            }
        }
        throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.INVALID_CREDENTIALS);
    }

    private LdapUser autoProvision(AlpineQueryManager qm) throws AlpineAuthenticationException {
        LdapUser user;
        block7: {
            LOGGER.debug("Provisioning: " + this.username);
            user = null;
            LdapConnectionWrapper ldap = new LdapConnectionWrapper();
            DirContext dirContext = null;
            try {
                dirContext = ldap.createDirContext();
                SearchResult result = ldap.searchForSingleUsername(dirContext, this.username);
                if (result != null) {
                    user = new LdapUser();
                    user.setUsername(this.username);
                    user.setDN(result.getNameInNamespace());
                    user.setEmail(ldap.getAttribute(result, LdapConnectionWrapper.ATTRIBUTE_MAIL));
                    user = (LdapUser)qm.persist((Object)user);
                    if (LdapConnectionWrapper.TEAM_SYNCHRONIZATION) {
                        List<String> groupDNs = ldap.getGroups(dirContext, user);
                        user = qm.synchronizeTeamMembership(user, groupDNs);
                    }
                    break block7;
                }
                LOGGER.warn("Could not find '" + this.username + "' in the directory while provisioning the user. Ensure '" + Config.AlpineKey.LDAP_ATTRIBUTE_NAME.getPropertyName() + "' is defined correctly");
                throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.UNMAPPED_ACCOUNT);
            }
            catch (NamingException e) {
                LOGGER.error("An error occurred while auto-provisioning an authenticated user", (Throwable)e);
                throw new AlpineAuthenticationException(AlpineAuthenticationException.CauseType.OTHER);
            }
            finally {
                ldap.closeQuietly(dirContext);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateCredentials() {
        block15: {
            boolean bl;
            AlpineQueryManager qm;
            LOGGER.debug("Validating credentials for: " + this.username);
            LdapConnectionWrapper ldap = new LdapConnectionWrapper();
            DirContext dirContext = null;
            LdapContext ldapContext = null;
            try {
                qm = new AlpineQueryManager();
                LdapUser ldapUser = qm.getLdapUser(this.username);
                if (ldapUser != null && ldapUser.getDN() != null && ldapUser.getDN().contains("=")) {
                    ldapContext = ldap.createLdapContext(ldapUser.getDN(), this.password);
                    LOGGER.debug("The supplied credentials are valid for: " + this.username);
                    boolean bl2 = true;
                    ldap.closeQuietly(ldapContext);
                    ldap.closeQuietly(dirContext);
                    return bl2;
                }
                dirContext = ldap.createDirContext();
                SearchResult result = ldap.searchForSingleUsername(dirContext, this.username);
                if (result == null) break block14;
                ldapContext = ldap.createLdapContext(result.getNameInNamespace(), this.password);
                LOGGER.debug("The supplied credentials are invalid for: " + this.username);
                bl = true;
                ldap.closeQuietly(ldapContext);
            }
            catch (NamingException e) {
                LOGGER.debug("An error occurred while attempting to validate credentials", (Throwable)e);
                break block15;
            }
            finally {
                ldap.closeQuietly(ldapContext);
                ldap.closeQuietly(dirContext);
            }
            ldap.closeQuietly(dirContext);
            return bl;
            {
                block14: {
                    finally {
                        qm.close();
                    }
                }
                ldap.closeQuietly(ldapContext);
            }
            ldap.closeQuietly(dirContext);
        }
        return false;
    }
}

