/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.Config;
import alpine.common.util.ByteUtil;
import alpine.model.ManagedUser;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mindrot.jbcrypt.BCrypt;

public final class PasswordService {
    private static final int ROUNDS = Config.getInstance().getPropertyAsInt((Config.Key)Config.AlpineKey.BCRYPT_ROUNDS);

    private PasswordService() {
    }

    public static char[] createHash(char[] password) {
        char[] prehash = PasswordService.createSha512Hash(password);
        return BCrypt.hashpw((String)new String(prehash), (String)BCrypt.gensalt((int)ROUNDS)).toCharArray();
    }

    public static char[] createHash(char[] password, char[] salt) {
        char[] prehash = PasswordService.createSha512Hash(password);
        return BCrypt.hashpw((String)new String(prehash), (String)new String(salt)).toCharArray();
    }

    public static boolean matches(char[] assertedPassword, ManagedUser user) {
        char[] prehash = PasswordService.createSha512Hash(assertedPassword);
        return BCrypt.checkpw((String)new String(prehash), (String)user.getPassword());
    }

    public static boolean shouldRehash(char[] bcryptHash) {
        int rounds;
        if (bcryptHash.length < 59) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(bcryptHash[4]);
        if (bcryptHash[5] != '$') {
            sb.append(bcryptHash[5]);
        }
        return (rounds = Integer.valueOf(sb.toString()).intValue()) < ROUNDS;
    }

    private static char[] createSha512Hash(char[] password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            digest.update(ByteUtil.toBytes((char[])password));
            byte[] byteData = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte data : byteData) {
                sb.append(Integer.toString((data & 0xFF) + 256, 16).substring(1));
            }
            char[] hash = new char[128];
            sb.getChars(0, sb.length(), hash, 0);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

