/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import alpine.common.logging.Logger;
import alpine.model.ApiKey;
import alpine.server.auth.AllowApiKeyInQueryParameter;
import alpine.server.auth.ApiKeyAuthenticationService;
import alpine.server.auth.JwtAuthenticationService;
import alpine.server.filters.ApiKeyUsageTracker;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.security.Principal;
import javax.naming.AuthenticationException;
import org.glassfish.jersey.server.ContainerRequest;
import org.owasp.security.logging.SecurityMarkers;

@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationFilter.class);
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        if (requestContext instanceof ContainerRequest) {
            JwtAuthenticationService jwtAuthService;
            ContainerRequest request = (ContainerRequest)requestContext;
            if ("OPTIONS".equals(request.getMethod())) {
                return;
            }
            Principal principal = null;
            boolean allowsApiKeyInQueryParameter = this.resourceInfo.getResourceMethod().isAnnotationPresent(AllowApiKeyInQueryParameter.class);
            ApiKeyAuthenticationService apiKeyAuthService = new ApiKeyAuthenticationService(request, allowsApiKeyInQueryParameter);
            if (apiKeyAuthService.isSpecified()) {
                try {
                    principal = apiKeyAuthService.authenticate();
                    if (principal instanceof ApiKey) {
                        ApiKey apiKey = (ApiKey)principal;
                        ApiKeyUsageTracker.onApiKeyUsed(apiKey);
                    }
                }
                catch (AuthenticationException e) {
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Invalid API key asserted");
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                    return;
                }
            }
            if ((jwtAuthService = new JwtAuthenticationService(request)).isSpecified()) {
                try {
                    principal = jwtAuthService.authenticate();
                }
                catch (AuthenticationException e) {
                    LOGGER.info(SecurityMarkers.SECURITY_FAILURE, "Invalid JWT asserted");
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                    return;
                }
            }
            if (principal == null) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            } else {
                requestContext.setProperty("Principal", (Object)principal);
            }
        }
    }
}

