/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public final class BlacklistUrlFilter
implements Filter {
    private String[] denyUrls = new String[0];
    private String[] ignoreUrls = new String[0];

    public void init(FilterConfig filterConfig) {
        String ignoreParam;
        String denyParam = filterConfig.getInitParameter("denyUrls");
        if (StringUtils.isNotBlank((CharSequence)denyParam)) {
            this.denyUrls = denyParam.split(",");
        }
        if (StringUtils.isNotBlank((CharSequence)(ignoreParam = filterConfig.getInitParameter("ignoreUrls")))) {
            this.ignoreUrls = ignoreParam.split(",");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            String requestUri = new URI(req.getRequestURI()).normalize().getPath();
            if (requestUri != null) {
                if (requestUri.contains("..")) {
                    res.setStatus(400);
                    return;
                }
                for (String url : this.denyUrls) {
                    if (!requestUri.startsWith(url.trim())) continue;
                    res.setStatus(403);
                    return;
                }
                for (String url : this.ignoreUrls) {
                    if (!requestUri.startsWith(url.trim())) continue;
                    res.setStatus(404);
                    return;
                }
            }
        }
        catch (URISyntaxException e) {
            res.setStatus(400);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

