/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public final class ClickjackingFilter
implements Filter {
    private String mode = "DENY";

    public void init(FilterConfig filterConfig) {
        String mode = filterConfig.getInitParameter("mode");
        String uri = filterConfig.getInitParameter("uri");
        if (StringUtils.isNotBlank((CharSequence)mode)) {
            if ("ALLOW-FROM".equals(mode)) {
                this.mode = mode + " " + uri;
            } else if ("DENY".equals(mode) || "SAMEORIGIN".equals(mode)) {
                this.mode = mode;
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        chain.doFilter(req, (ServletResponse)response);
        response.addHeader("X-Frame-Options", this.mode);
    }

    public void destroy() {
    }
}

