/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import alpine.common.util.BooleanUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class HstsFilter
implements Filter {
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int DEFAULT_MAX_AGE = 86400;
    private int httpsPort = 443;
    private long maxAge = 86400L;
    private boolean includeSubdomains;

    public void init(FilterConfig filterConfig) throws ServletException {
        String portString = filterConfig.getInitParameter("httpsPort");
        try {
            this.httpsPort = Integer.valueOf(portString);
        }
        catch (NumberFormatException e) {
            this.httpsPort = 443;
        }
        String maxAgeString = filterConfig.getInitParameter("maxAge");
        try {
            this.maxAge = Long.valueOf(maxAgeString);
        }
        catch (NumberFormatException e) {
            this.maxAge = 86400L;
        }
        this.includeSubdomains = BooleanUtil.valueOf((String)filterConfig.getInitParameter("includeSubdomains"));
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (request.isSecure()) {
            if (this.includeSubdomains) {
                response.setHeader("Strict-Transport-Security", "max-age=" + this.maxAge + "; includeSubDomains");
            } else {
                response.setHeader("Strict-Transport-Security", "max-age=" + this.maxAge + ";");
            }
        } else {
            response.setStatus(301);
            StringBuilder sb = new StringBuilder();
            sb.append("https://").append(request.getServerName());
            if (this.httpsPort != 443) {
                sb.append(":").append(this.httpsPort);
            }
            if (request.getContextPath() != null) {
                sb.append(request.getContextPath());
            }
            if (request.getServletPath() != null) {
                sb.append(request.getServletPath());
            }
            if (request.getPathInfo() != null) {
                sb.append(request.getPathInfo());
            }
            if (request.getQueryString() != null && request.getQueryString().length() > 0) {
                sb.append("?").append(request.getQueryString());
            }
            response.setHeader("Location", sb.toString());
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

