/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.slf4j.MDC;

@Provider
@Priority(value=1)
public class RequestIdFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Pattern REQUEST_ID_PATTERN = Pattern.compile("^[A-Za-z0-9._\\-=+]{16,192}$");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestId = requestContext.getHeaderString("X-Request-Id");
        if (requestId == null || !REQUEST_ID_PATTERN.matcher(requestId).matches()) {
            requestId = UUID.randomUUID().toString();
        }
        requestContext.setProperty("requestId", (Object)requestId);
        MDC.put((String)"requestId", (String)requestId);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object object = requestContext.getProperty("requestId");
        if (object instanceof String) {
            String requestId = (String)object;
            responseContext.getHeaders().putSingle((Object)"X-Request-Id", (Object)requestId);
        }
        MDC.remove((String)"requestId");
    }
}

