/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.health;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.health.HealthCheckResponse;

class HealthCheckResponseBuilder
extends org.eclipse.microprofile.health.HealthCheckResponseBuilder {
    private String name;
    private HealthCheckResponse.Status status = HealthCheckResponse.Status.DOWN;
    private final Map<String, Object> data = new HashMap<String, Object>();

    HealthCheckResponseBuilder() {
    }

    public org.eclipse.microprofile.health.HealthCheckResponseBuilder name(String name) {
        this.name = name;
        return this;
    }

    public org.eclipse.microprofile.health.HealthCheckResponseBuilder withData(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    public org.eclipse.microprofile.health.HealthCheckResponseBuilder withData(String key, long value) {
        this.data.put(key, value);
        return this;
    }

    public org.eclipse.microprofile.health.HealthCheckResponseBuilder withData(String key, boolean value) {
        this.data.put(key, value);
        return this;
    }

    public org.eclipse.microprofile.health.HealthCheckResponseBuilder up() {
        this.status = HealthCheckResponse.Status.UP;
        return this;
    }

    public org.eclipse.microprofile.health.HealthCheckResponseBuilder down() {
        this.status = HealthCheckResponse.Status.DOWN;
        return this;
    }

    public org.eclipse.microprofile.health.HealthCheckResponseBuilder status(boolean up) {
        this.status = up ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        return this;
    }

    public HealthCheckResponse build() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IllegalArgumentException("Health check responses must provide a name");
        }
        return new HealthCheckResponse(this.name, this.status, Optional.of(this.data).filter(Predicate.not(Map::isEmpty)));
    }
}

