/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.jsonwebtoken.lang.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class TrimmedStringArrayDeserializer
extends JsonDeserializer<String[]> {
    public String[] deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        JsonNode node = (JsonNode)jsonParser.readValueAsTree();
        if (node.isArray()) {
            Iterator elements = node.elements();
            while (elements.hasNext()) {
                JsonNode childNode = (JsonNode)elements.next();
                String value = StringUtils.trimToNull((String)childNode.asText());
                if (value == null) continue;
                list.add(value);
            }
        }
        if (Collections.isEmpty(list)) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }
}

