/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.mail;

import alpine.security.crypto.RelaxedX509TrustManager;
import alpine.server.mail.SendMailException;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import org.eclipse.angus.mail.util.MailSSLSocketFactory;

public class SendMail {
    private Address from;
    private Address[] to;
    private Address[] cc;
    private Address[] bcc;
    private String subject;
    private String body;
    private String bodyMimeType;
    private File[] attachments = new File[0];
    private String host;
    private int port;
    private String username;
    private String password;
    private boolean useStartTLS;
    private boolean useNTLM;
    private boolean smtpauth;
    private boolean trustCert;
    private boolean debug;

    public SendMail from(String from) throws SendMailException {
        this.from = this.parseAddress(from);
        return this;
    }

    public SendMail to(String[] to) throws SendMailException {
        this.to = this.parseAddress(to);
        return this;
    }

    public SendMail to(String to) throws SendMailException {
        this.to = this.parseAddress(new String[]{to});
        return this;
    }

    public SendMail cc(String[] cc) throws SendMailException {
        this.cc = this.parseAddress(cc);
        return this;
    }

    public SendMail cc(String cc) throws SendMailException {
        this.cc = this.parseAddress(new String[]{cc});
        return this;
    }

    public SendMail bcc(String[] bcc) throws SendMailException {
        this.bcc = this.parseAddress(bcc);
        return this;
    }

    public SendMail bcc(String bcc) throws SendMailException {
        this.bcc = this.parseAddress(new String[]{bcc});
        return this;
    }

    public SendMail subject(String subject) {
        this.subject = subject;
        return this;
    }

    public SendMail body(String body) {
        this.body = body;
        return this;
    }

    public SendMail bodyMimeType(String bodyMimeType) {
        this.bodyMimeType = bodyMimeType;
        return this;
    }

    public SendMail attachments(File[] attachments) {
        this.attachments = attachments == null ? null : (File[])attachments.clone();
        return this;
    }

    public SendMail host(String host) {
        this.host = host;
        return this;
    }

    public SendMail port(int port) {
        this.port = port;
        return this;
    }

    public SendMail username(String username) {
        this.username = username;
        return this;
    }

    public SendMail password(String password) {
        this.password = password;
        return this;
    }

    public SendMail useStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
        return this;
    }

    public SendMail useNTLM(boolean useNTLM) {
        this.useNTLM = useNTLM;
        return this;
    }

    public SendMail smtpauth(boolean smtpauth) {
        this.smtpauth = smtpauth;
        return this;
    }

    public SendMail trustCert(boolean trustCert) {
        this.trustCert = trustCert;
        return this;
    }

    public SendMail debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    private Address parseAddress(String address) throws SendMailException {
        return this.parseAddress(new String[]{address})[0];
    }

    private Address[] parseAddress(String[] addresses) throws SendMailException {
        InternetAddress[] internetAddresses = new InternetAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            try {
                internetAddresses[i] = new InternetAddress(addresses[i]);
                continue;
            }
            catch (AddressException e) {
                throw new SendMailException("An error occurred processing internet addresses", e);
            }
        }
        return internetAddresses;
    }

    public void send() throws SendMailException {
        Properties props = new Properties();
        if (this.trustCert) {
            MailSSLSocketFactory sf;
            try {
                sf = new MailSSLSocketFactory();
                sf.setTrustAllHosts(true);
                TrustManager[] trustManagers = new TrustManager[]{new RelaxedX509TrustManager()};
                sf.setTrustManagers(trustManagers);
            }
            catch (GeneralSecurityException e) {
                throw new SendMailException("An error occurred while configuring trust managers", e);
            }
            props.put("mail.smtp.ssl.socketFactory", sf);
        } else if (this.useStartTLS) {
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        props.put("mail.smtp.socketFactory.port", (Object)this.port);
        props.put("mail.smtp.auth", (Object)this.smtpauth);
        props.put("mail.smtp.starttls.enable", (Object)this.useStartTLS);
        if (this.useNTLM) {
            props.put("mail.smtp.auth.ntlm.domain", this.host);
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SendMail.this.username, SendMail.this.password);
            }
        });
        session.setDebug(this.debug);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom(this.from);
            message.setRecipients(Message.RecipientType.TO, this.to);
            if (this.cc != null && this.cc.length > 0) {
                message.setRecipients(Message.RecipientType.CC, this.cc);
            }
            if (this.bcc != null && this.bcc.length > 0) {
                message.setRecipients(Message.RecipientType.BCC, this.bcc);
            }
            message.setSubject(this.subject);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            if (this.bodyMimeType != null) {
                messageBodyPart.setContent((Object)this.body, this.bodyMimeType);
            } else {
                messageBodyPart.setText(this.body);
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (File file : this.attachments) {
                messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(file);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(file.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new SendMailException("An error occurred while sending email", e);
        }
    }
}

