/*
 * Decompiled with CFR 0.152.
 */
package alpine.server.auth;

import alpine.common.logging.Logger;
import alpine.model.ApiKey;
import alpine.persistence.AlpineQueryManager;
import alpine.security.ApiKeyDecoder;
import alpine.security.InvalidApiKeyFormatException;
import alpine.server.auth.AuthenticationService;
import java.security.MessageDigest;
import java.security.Principal;
import javax.naming.AuthenticationException;
import org.glassfish.jersey.server.ContainerRequest;

public class ApiKeyAuthenticationService
implements AuthenticationService {
    private static final Logger LOGGER = Logger.getLogger(ApiKeyAuthenticationService.class);
    private final String assertedApiKey;

    public ApiKeyAuthenticationService(ContainerRequest request, boolean allowByQuery) {
        this.assertedApiKey = request.getHeaderString("X-Api-Key") != null ? request.getHeaderString("X-Api-Key") : (allowByQuery ? (String)request.getUriInfo().getQueryParameters().getFirst((Object)"apiKey") : null);
    }

    @Override
    public boolean isSpecified() {
        return this.assertedApiKey != null;
    }

    @Override
    public Principal authenticate() throws AuthenticationException {
        ApiKey decodedApiKey;
        try {
            decodedApiKey = ApiKeyDecoder.decode((String)this.assertedApiKey);
        }
        catch (InvalidApiKeyFormatException e) {
            LOGGER.debug("Format of the provided API key is invalid", (Throwable)e);
            throw new AuthenticationException();
        }
        try (AlpineQueryManager qm = new AlpineQueryManager();){
            ApiKey apiKey = qm.getApiKeyByPublicId(decodedApiKey.getPublicId());
            if (apiKey == null) {
                LOGGER.debug("No API key found for public ID " + decodedApiKey.getPublicId());
                throw new AuthenticationException();
            }
            if (!MessageDigest.isEqual(decodedApiKey.getSecretHash().getBytes(), apiKey.getSecretHash().getBytes())) {
                LOGGER.debug("API key secret hashes do not match");
                throw new AuthenticationException();
            }
            ApiKey apiKey2 = apiKey;
            return apiKey2;
        }
    }
}

